/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.wicket.target;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.cocoon.servlet.RequestProcessor;
import org.apache.cocoon.sitemap.NoMatchingPipelineException;
import org.apache.cocoon.spring.configurator.WebAppContextUtils;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.protocol.http.request.WebErrorCodeResponseTarget;
import org.apache.wicket.settings.IExceptionSettings;
import org.springframework.beans.factory.BeanFactory;

public class CocoonSitemapRequestTarget
implements IRequestTarget {
    private RequestProcessor requestProcessor;
    private final String mountPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CocoonSitemapRequestTarget(String sitemapPath, String mountPath) {
        this.mountPath = mountPath;
        CocoonSitemapRequestTarget cocoonSitemapRequestTarget = this;
        synchronized (cocoonSitemapRequestTarget) {
            if (this.requestProcessor != null) {
                return;
            }
            try {
                this.requestProcessor = new RequestProcessor(WebApplication.get().getServletContext(), sitemapPath, (BeanFactory)WebAppContextUtils.getCurrentWebApplicationContext());
            }
            catch (RequestProcessor.SitemapNotFoundException e) {
                throw new CocoonRuntimeException("Can't initialize Cocoon sitemap.", e);
            }
            catch (RequestProcessor.InvalidBaseUrlException e) {
                throw new CocoonRuntimeException("Invalid base URL for the Cocoon sitemap.", e);
            }
            catch (RequestProcessor.SitemapInitializationException e) {
                throw new CocoonRuntimeException("Can't initialize Cocoon sitemap.", e);
            }
        }
    }

    public void detach(RequestCycle requestCycle) {
    }

    public void respond(RequestCycle requestCycle) {
        try {
            CocoonWicketRequestWrapper request = new CocoonWicketRequestWrapper(((WebRequest)requestCycle.getRequest()).getHttpServletRequest());
            this.requestProcessor.service((HttpServletRequest)request, ((WebResponse)requestCycle.getResponse()).getHttpServletResponse());
        }
        catch (NoMatchingPipelineException e) {
            WebApplication.get().getExceptionSettings().setUnexpectedExceptionDisplay(IExceptionSettings.SHOW_INTERNAL_ERROR_PAGE);
            RequestCycle.get().setRequestTarget((IRequestTarget)new WebErrorCodeResponseTarget(404));
        }
        catch (Exception e) {
            throw new CocoonRuntimeException("Error occurred while executing a Cocoon sitemap.", e);
        }
    }

    private class CocoonWicketRequestWrapper
    extends HttpServletRequestWrapper {
        private final HttpServletRequest request;

        public CocoonWicketRequestWrapper(HttpServletRequest request) {
            super(request);
            this.request = request;
        }

        public String getServletPath() {
            return this.request.getServletPath().substring(CocoonSitemapRequestTarget.this.mountPath.length());
        }
    }

    public static class CocoonRuntimeException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public CocoonRuntimeException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

