/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.pipeline;

import java.io.ByteArrayOutputStream;
import org.apache.cocoon.pipeline.CachingPipeline;
import org.apache.cocoon.pipeline.caching.CacheKey;
import org.apache.cocoon.pipeline.caching.CacheRefreshJob;
import org.apache.cocoon.pipeline.caching.CacheRefreshManager;
import org.apache.cocoon.pipeline.caching.CacheValue;
import org.apache.cocoon.pipeline.caching.CompleteCacheValue;
import org.apache.cocoon.pipeline.component.PipelineComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncCachePipeline<T extends PipelineComponent>
extends CachingPipeline<T>
implements CacheRefreshJob {
    private final Log logger = LogFactory.getLog(this.getClass());
    private CacheRefreshManager cacheRefreshManager;

    @Override
    public void execute() throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Used cache: " + this.cache));
        }
        this.cacheKey = this.constructCacheKey();
        CacheValue cachedValue = this.getCachedValue(this.cacheKey);
        if (cachedValue != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Write cache value to output stream: " + cachedValue));
            }
            cachedValue.writeTo(this.cachingOutputStream.getOutputStream());
            if (!this.isCacheKeyValid(cachedValue)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Cached value is not up to date. Delegating to " + this.cacheRefreshManager));
                }
                this.cacheRefreshManager.refreshCacheValue(this.cacheKey, this);
            }
            return;
        }
        this.invokeStarter();
        CompleteCacheValue cacheValue = new CompleteCacheValue(this.cachingOutputStream.getContent(), this.cacheKey);
        this.setCachedValue(this.cacheKey, cacheValue);
    }

    public CacheRefreshManager getCacheRefreshManager() {
        return this.cacheRefreshManager;
    }

    @Override
    public void refresh(CacheKey cacheKey) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.getFinisher().setOutputStream(baos);
        this.invokeStarter();
        this.setCachedValue(cacheKey, new CompleteCacheValue(baos.toByteArray(), cacheKey));
    }

    public void setCacheRefreshManager(CacheRefreshManager cacheRefreshManager) {
        this.cacheRefreshManager = cacheRefreshManager;
    }
}

