/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.pipeline;

import java.io.OutputStream;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import org.apache.cocoon.pipeline.Pipeline;
import org.apache.cocoon.pipeline.ProcessingException;
import org.apache.cocoon.pipeline.SetupException;
import org.apache.cocoon.pipeline.component.Consumer;
import org.apache.cocoon.pipeline.component.Finisher;
import org.apache.cocoon.pipeline.component.PipelineComponent;
import org.apache.cocoon.pipeline.component.Producer;
import org.apache.cocoon.pipeline.component.Starter;
import org.apache.cocoon.pipeline.util.StringRepresentation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPipeline<T extends PipelineComponent>
implements Pipeline<T> {
    private final LinkedList<T> components = new LinkedList();
    private final Log logger = LogFactory.getLog(this.getClass());
    private boolean setupDone;

    @Override
    public void addComponent(T pipelineComponent) {
        if (this.setupDone) {
            throw new SetupException(new IllegalStateException("Pass all pipeline components to the pipeline before calling this method."));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Adding component " + pipelineComponent + " to pipeline [" + this + "]."));
        }
        this.components.add(pipelineComponent);
    }

    @Override
    public void execute() throws Exception {
        if (!this.setupDone) {
            throw new ProcessingException(new IllegalStateException("The pipeline wasn't setup correctly. Call #setup() first."));
        }
        this.invokeStarter();
    }

    @Override
    public String getContentType() {
        return this.getFinisher().getContentType();
    }

    @Override
    public long getLastModified() {
        return -1L;
    }

    @Override
    public void setConfiguration(Map<String, ? extends Object> parameters) {
    }

    @Override
    public void setup(OutputStream outputStream) {
        this.setup(outputStream, null);
    }

    @Override
    public void setup(OutputStream outputStream, Map<String, Object> parameters) {
        if (outputStream == null) {
            throw new SetupException("An output stream must be passed.");
        }
        this.setupComponents(outputStream, parameters);
        this.setupDone = true;
    }

    public String toString() {
        return StringRepresentation.buildString(this, "components=" + this.getComponents());
    }

    protected LinkedList<T> getComponents() {
        return this.components;
    }

    protected Finisher getFinisher() {
        return (Finisher)this.components.getLast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeStarter() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Invoking first component of " + this));
        }
        try {
            Starter starter = (Starter)this.components.getFirst();
            starter.execute();
        }
        finally {
            for (PipelineComponent pipelineComponent : this.getComponents()) {
                pipelineComponent.finish();
            }
        }
    }

    protected void setupComponents(OutputStream outputStream, Map<String, Object> parameters) {
        PipelineComponent first = (PipelineComponent)this.components.getFirst();
        if (!(first instanceof Starter)) {
            String msg = "Cannot execute pipeline, first pipeline component is no starter";
            this.logger.error((Object)msg);
            throw new SetupException(new IllegalStateException(msg));
        }
        PipelineComponent last = (PipelineComponent)this.components.getLast();
        if (!(last instanceof Finisher)) {
            String msg = "Cannot execute pipeline, last pipeline component is no finisher";
            this.logger.error((Object)msg);
            throw new SetupException(new IllegalStateException(msg));
        }
        PipelineComponent currentComponent = first;
        first.setup(parameters);
        ListIterator<T> i = this.components.listIterator(1);
        while (i.hasNext()) {
            PipelineComponent nextComponent = (PipelineComponent)i.next();
            this.linkComponents(currentComponent, nextComponent);
            currentComponent = nextComponent;
            currentComponent.setup(parameters);
        }
        ((Finisher)last).setOutputStream(outputStream);
    }

    private void linkComponents(PipelineComponent firstComponent, PipelineComponent secondComponent) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Going to link the component " + firstComponent + " with " + secondComponent + "."));
        }
        if (!(firstComponent instanceof Producer)) {
            String msg = "Cannot link components: First component (" + firstComponent + ") is no producer.";
            throw new SetupException(new IllegalStateException(msg));
        }
        if (!(secondComponent instanceof Consumer)) {
            String msg = "Cannot link components: Second component (" + secondComponent + ") is no consumer.";
            throw new SetupException(new IllegalStateException(msg));
        }
        ((Producer)firstComponent).setConsumer((Consumer)secondComponent);
    }
}

