/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servlet.util;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.cocoon.servlet.controller.ControllerContextHelper;
import org.apache.cocoon.servlet.util.HttpContextHelper;
import org.apache.cocoon.servlet.util.SettingsHelper;
import org.apache.cocoon.servletservice.util.ServletServiceRequest;
import org.apache.cocoon.sitemap.objectmodel.ObjectModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectModelProvider {
    private ObjectModelProvider() {
        throw new AssertionError();
    }

    public static ObjectModel provide(Map<String, Object> parameters) {
        ObjectModel objectModel = new ObjectModel(parameters);
        Map cocoon = objectModel.getCocoonObject();
        HttpServletRequest request = HttpContextHelper.getRequest(parameters);
        cocoon.put("request", new ObjectModelRequest(request));
        cocoon.put("response", HttpContextHelper.getResponse(parameters));
        cocoon.put("context", HttpContextHelper.getServletContext(parameters));
        cocoon.put("settings", SettingsHelper.getSettings(parameters));
        Map<String, Object> controllerContext = ControllerContextHelper.getContext(parameters);
        if (controllerContext != null) {
            cocoon.put("controller", controllerContext);
        }
        return objectModel;
    }

    public static class ObjectModelRequest
    extends HttpServletRequestWrapper {
        public ObjectModelRequest(HttpServletRequest request) {
            super(request);
        }

        public String get(String key) {
            return this.getParameter(key);
        }

        public boolean isSsf() {
            return this.getRequest() instanceof ServletServiceRequest;
        }
    }
}

