/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servlet.ssf;

import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import org.apache.cocoon.pipeline.ProcessingException;
import org.apache.cocoon.sax.AbstractSAXTransformer;
import org.apache.cocoon.sax.util.XMLUtils;
import org.apache.cocoon.xml.sax.SAXBuffer;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletServiceTransformer
extends AbstractSAXTransformer {
    private URL service;
    private URLConnection servletConnection;

    public void startDocument() throws SAXException {
        this.startSAXRecording();
        this.getSAXConsumer().startDocument();
    }

    public void endDocument() throws SAXException {
        if (this.service == null) {
            throw new IllegalArgumentException("ServletServiceTransformer has no service set.");
        }
        this.getSAXConsumer().endDocument();
        SAXBuffer saxBuffer = this.endSAXRecording();
        try {
            XMLUtils.toOutputStream((OutputStream)this.getUrlConnection().getOutputStream(), (SAXBuffer)saxBuffer);
            XMLUtils.toSax((URLConnection)this.getUrlConnection(), (ContentHandler)this.getSAXConsumer());
        }
        catch (IOException e) {
            throw new ProcessingException("Can't stream SaxBuffer into the output stream of the URL " + this.getUrlConnection().getURL());
        }
    }

    private URLConnection getUrlConnection() {
        if (this.servletConnection == null) {
            try {
                this.servletConnection = this.service.openConnection();
            }
            catch (IOException e) {
                throw new ProcessingException("Can't use connected servlet service: " + this.service, (Throwable)e);
            }
        }
        return this.servletConnection;
    }

    public void setConfiguration(Map<String, ? extends Object> configuration) {
        try {
            this.service = new URL((String)configuration.get("service"));
        }
        catch (MalformedURLException e) {
            throw new ProcessingException("Can't create an URL for " + configuration.get("service") + ".", (Throwable)e);
        }
    }
}

