/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servlet.controller;

import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.servlet.util.HttpContextHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerContextHelper {
    private static final Log LOG = LogFactory.getLog(ControllerContextHelper.class);
    private static final String CONTEXT_OBJECT = ControllerContextHelper.class.getName();

    public static Map<String, Object> getContext(Map<String, ? extends Object> parameters) {
        HttpServletRequest request = HttpContextHelper.getRequest(parameters);
        Object controllerContext = request.getAttribute(CONTEXT_OBJECT);
        if (controllerContext instanceof Map) {
            return (Map)controllerContext;
        }
        if (controllerContext != null) {
            LOG.warn((Object)("The parameters contain an entry with the key " + CONTEXT_OBJECT + " but it is not a map."));
        }
        return Collections.EMPTY_MAP;
    }

    public static void storeContext(Map<String, Object> controllerContext, Map<String, Object> parameters) {
        HttpServletRequest request = HttpContextHelper.getRequest(parameters);
        ControllerContextHelper.storeContext(controllerContext, request);
    }

    public static void storeContext(Map<String, Object> controllerContext, HttpServletRequest request) {
        request.setAttribute(CONTEXT_OBJECT, controllerContext);
    }
}

