/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servlet.component;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.cocoon.pipeline.ProcessingException;
import org.apache.cocoon.pipeline.component.AbstractPipelineComponent;
import org.apache.cocoon.pipeline.component.Finisher;
import org.apache.cocoon.pipeline.component.Starter;
import org.apache.cocoon.servlet.util.HttpContextHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedirectorComponent
extends AbstractPipelineComponent
implements Starter,
Finisher {
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private Map<String, Object> parameters;
    private String uri;
    private URLConnection urlConnection;
    private OutputStream outputStream;

    public void execute() {
        HttpServletResponse response = HttpContextHelper.getResponse(this.parameters);
        try {
            if (this.uri.startsWith("servlet:")) {
                int bytesRead;
                InputStream inputStream = this.getURLConnection().getInputStream();
                byte[] data = new byte[1024];
                while ((bytesRead = inputStream.read(data, 0, data.length)) != -1) {
                    this.outputStream.write(data, 0, bytesRead);
                }
            } else {
                String location = response.encodeRedirectURL(this.uri);
                response.sendRedirect(location);
            }
        }
        catch (IOException e) {
            this.logger.error((Object)("Can't redirect to " + this.uri), (Throwable)e);
            throw new ProcessingException((Throwable)e);
        }
    }

    private URLConnection getURLConnection() {
        if (this.urlConnection == null) {
            try {
                this.urlConnection = new URL(this.uri).openConnection();
            }
            catch (IOException e) {
                throw new ProcessingException("Can't connect to the URI " + this.uri, (Throwable)e);
            }
        }
        return this.urlConnection;
    }

    public String getContentType() {
        return this.getURLConnection().getContentType();
    }

    public void setConfiguration(Map<String, ? extends Object> configuration) {
        this.uri = (String)configuration.get("uri");
    }

    public void setup(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public String toString() {
        return "RedirectorComponent(" + this.uri + ")";
    }
}

