/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servlet.collector;

import org.apache.cocoon.pipeline.CachingPipeline;
import org.apache.cocoon.pipeline.Pipeline;
import org.apache.cocoon.pipeline.caching.CacheKey;
import org.apache.cocoon.servlet.collector.CollectorDataStore;
import org.apache.cocoon.servlet.collector.InvalidStatusCodeException;
import org.apache.cocoon.servlet.collector.ThreadLocalCollectorDataStore;
import org.apache.cocoon.sitemap.Invocation;
import org.apache.cocoon.sitemap.node.InvocationResult;
import org.apache.cocoon.sitemap.node.SerializeNode;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public class ResponseHeaderCollector {
    private static CollectorDataStore collectorDataStore = new ThreadLocalCollectorDataStore();
    private static final String KEY_ETAG = ResponseHeaderCollector.class.getName() + "/etag";
    private static final String KEY_IF_MODIFIED_SINCE = ResponseHeaderCollector.class.getName() + "/if-modified-since";
    private static final String KEY_IF_NONE_MATCH = ResponseHeaderCollector.class.getName() + "/if-none-match";
    private static final String KEY_LAST_MODIFIED = ResponseHeaderCollector.class.getName() + "/last-modified";
    private static final String KEY_MIME_TYPE = ResponseHeaderCollector.class.getName() + "/mime-type";
    private static final String KEY_PIPELINE_EXECUTED = ResponseHeaderCollector.class.getName() + "/pipeline-executed";
    private static final String KEY_REQUEST_METHOD = ResponseHeaderCollector.class.getName() + "/method";
    private static final String KEY_STATUS_CODE = ResponseHeaderCollector.class.getName() + "/status-code";

    @Around(value="execution(* org.apache.cocoon.pipeline.Pipeline.execute(..))")
    public Object interceptInvoke(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        String newValue;
        CachingPipeline cachingPipeline;
        CacheKey cacheKey;
        ResponseHeaderCollector.setModifiedResponse(false);
        Pipeline pipeline = (Pipeline)proceedingJoinPoint.getTarget();
        long ifModifiedSince = ResponseHeaderCollector.getIfLastModifiedSince();
        long lastModified = pipeline.getLastModified();
        String noneMatch = ResponseHeaderCollector.getIfNoneMatch();
        if (pipeline instanceof CachingPipeline && (cacheKey = (cachingPipeline = (CachingPipeline)pipeline).getCacheKey()) != null) {
            ResponseHeaderCollector.setETag(Integer.toHexString(cacheKey.hashCode()));
        }
        if (lastModified > -1L || ResponseHeaderCollector.getLastModified() <= 0L) {
            ResponseHeaderCollector.setLastModified(lastModified);
        }
        Object result = null;
        boolean repeatPipeline = true;
        String eTag = ResponseHeaderCollector.getETag();
        if (eTag != null && noneMatch != null && noneMatch.equals(eTag)) {
            repeatPipeline = false;
        }
        if (repeatPipeline && ifModifiedSince > 0L && lastModified > 0L && ifModifiedSince / 1000L >= lastModified / 1000L) {
            repeatPipeline = false;
        }
        if (repeatPipeline) {
            ResponseHeaderCollector.setModifiedResponse(true);
            result = proceedingJoinPoint.proceed();
        }
        if ((newValue = pipeline.getContentType()) != null) {
            ResponseHeaderCollector.setMimeType(newValue);
        }
        return result;
    }

    @Around(value="execution(* org.apache.cocoon.sitemap.node.SerializeNode.invoke(..)) && args(invocation)")
    public Object interceptInvoke(ProceedingJoinPoint proceedingJoinPoint, Invocation invocation) throws Throwable {
        SerializeNode target = (SerializeNode)proceedingJoinPoint.getTarget();
        String statusCode = invocation.resolveParameter((String)target.getParameters().get("status-code"));
        InvocationResult invocationResult = (InvocationResult)proceedingJoinPoint.proceed();
        if (invocationResult.isContinued() && statusCode != null) {
            try {
                ResponseHeaderCollector.setStatusCode(Integer.valueOf(statusCode));
            }
            catch (NumberFormatException nfe) {
                throw new InvalidStatusCodeException("The status-code '" + statusCode + " is not valid number.", nfe);
            }
        }
        return invocationResult;
    }

    public void setCollectorDataStore(CollectorDataStore collectorDataStore) {
        ResponseHeaderCollector.collectorDataStore = collectorDataStore;
    }

    public static String getETag() {
        return (String)collectorDataStore.get(KEY_ETAG);
    }

    public static long getIfLastModifiedSince() {
        Number attribute = (Number)collectorDataStore.get(KEY_IF_MODIFIED_SINCE);
        if (attribute == null) {
            return -1L;
        }
        return attribute.longValue();
    }

    public static String getIfNoneMatch() {
        return (String)collectorDataStore.get(KEY_IF_NONE_MATCH);
    }

    public static long getLastModified() {
        Object lastModified = collectorDataStore.get(KEY_LAST_MODIFIED);
        if (lastModified == null) {
            return -1L;
        }
        return (Long)lastModified;
    }

    public static String getMimeType() {
        return (String)collectorDataStore.get(KEY_MIME_TYPE);
    }

    public static String getRequestMethod() {
        return (String)collectorDataStore.get(KEY_REQUEST_METHOD);
    }

    public static int getStatusCode() {
        Integer statusCode = (Integer)collectorDataStore.get(KEY_STATUS_CODE);
        if (statusCode == null) {
            return 200;
        }
        return statusCode;
    }

    public static boolean isModifiedResponse() {
        return (Boolean)collectorDataStore.get(KEY_PIPELINE_EXECUTED);
    }

    public static void setETag(String etag) {
        collectorDataStore.set(KEY_ETAG, etag);
    }

    public static void setIfLastModifiedSince(long ifLastModifiedSince) {
        collectorDataStore.set(KEY_IF_MODIFIED_SINCE, ifLastModifiedSince);
    }

    public static void setIfNoneMatch(String ifNoneMatch) {
        collectorDataStore.set(KEY_IF_NONE_MATCH, ifNoneMatch);
    }

    public static void setLastModified(Long lastModified) {
        collectorDataStore.set(KEY_LAST_MODIFIED, lastModified);
    }

    public static void setMimeType(String mimeType) {
        collectorDataStore.set(KEY_MIME_TYPE, mimeType);
    }

    public static void setModifiedResponse(boolean executed) {
        collectorDataStore.set(KEY_PIPELINE_EXECUTED, executed);
    }

    public static void setRequestMethod(String method) {
        collectorDataStore.set(KEY_REQUEST_METHOD, method);
    }

    public static void setStatusCode(int statusCode) {
        collectorDataStore.set(KEY_STATUS_CODE, statusCode);
    }
}

