/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cocoon.servlet.RequestProcessor;
import org.apache.cocoon.spring.configurator.WebAppContextUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;

public class XMLSitemapServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private RequestProcessor requestProcessor;
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.lazyInitialize();
        try {
            this.requestProcessor.service(req, resp);
        }
        catch (RuntimeException e) {
            this.wrapException(e, "Cocoon can't process the request.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInitialize() throws ServletException {
        XMLSitemapServlet xMLSitemapServlet = this;
        synchronized (xMLSitemapServlet) {
            if (this.requestProcessor != null) {
                return;
            }
            try {
                this.requestProcessor = new RequestProcessor(this.getServletContext(), this.getInitParameter("sitemap-path"), (BeanFactory)WebAppContextUtils.getCurrentWebApplicationContext());
            }
            catch (Exception e) {
                this.wrapException(e, "Can't initialize the RequestProcessor correctly.");
            }
        }
    }

    private ServletException wrapException(Exception e, String msg) {
        this.logger.error((Object)msg, (Throwable)e);
        ServletException servletException = new ServletException(msg, (Throwable)e);
        if (servletException.getCause() == null) {
            servletException.initCause((Throwable)e);
        }
        return servletException;
    }
}

