/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cocoon.callstack.CallStack;
import org.apache.cocoon.configuration.Settings;
import org.apache.cocoon.servlet.collector.ResponseHeaderCollector;
import org.apache.cocoon.servlet.util.HttpContextHelper;
import org.apache.cocoon.servlet.util.ManifestUtils;
import org.apache.cocoon.servlet.util.ObjectModelProvider;
import org.apache.cocoon.servlet.util.SettingsHelper;
import org.apache.cocoon.servletservice.CallStackHelper;
import org.apache.cocoon.sitemap.Invocation;
import org.apache.cocoon.sitemap.InvocationImpl;
import org.apache.cocoon.sitemap.SitemapBuilder;
import org.apache.cocoon.sitemap.node.SitemapNode;
import org.apache.cocoon.spring.configurator.ResourceUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestProcessor {
    private URL baseURL;
    private BeanFactory beanFactory;
    private boolean inServletServiceFramework;
    private final Log logger = LogFactory.getLog(this.getClass());
    private ServletContext servletContext;
    private SitemapNode sitemapNode;
    private String sitemapPath;
    private String version = "";

    public RequestProcessor(ServletContext servletContext, String sitemapPath, BeanFactory beanFactory) throws SitemapNotFoundException, InvalidBaseUrlException, SitemapInitializationException {
        if (servletContext == null) {
            throw new NullPointerException("A 'ServletContext' has to be passed.");
        }
        if (beanFactory == null) {
            throw new NullPointerException("A Spring 'BeanFactory' has to be passed.");
        }
        this.servletContext = servletContext;
        this.sitemapPath = sitemapPath;
        this.beanFactory = beanFactory;
        this.initializeInServletServiceFramework();
        this.initializeBaseURL();
        this.initializeVersionNumber();
        this.initializeSitemap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        long start = System.nanoTime();
        this.logRequest(request);
        try {
            if (this.inServletServiceFramework) {
                this.sendSitemapResponse(request, response);
                return;
            }
            try {
                CallStackHelper.enterServlet((ServletContext)this.servletContext, (HttpServletRequest)request, (HttpServletResponse)response);
                this.sendSitemapResponse(request, response);
            }
            finally {
                CallStackHelper.leaveServlet();
            }
        }
        finally {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Sitemap execution for " + request.getRequestURI() + " took " + (float)(System.nanoTime() - start) / 1000000.0f + " ms."));
            }
        }
    }

    private String calcSitemapRequestURI(HttpServletRequest request) {
        if (!this.inServletServiceFramework) {
            return request.getServletPath();
        }
        String contextPath = request.getContextPath();
        String mountPath = request.getServletPath();
        return request.getRequestURI().substring(contextPath.length() + mountPath.length());
    }

    private URL getBaseURL() {
        return this.baseURL;
    }

    private static Map<String, Object> getInvocationParameters(HttpServletRequest req) {
        HashMap<String, Object> invocationParameters = new HashMap<String, Object>();
        Enumeration names = req.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            invocationParameters.put(name, req.getParameter(name));
        }
        return invocationParameters;
    }

    private String getSitemapPath() {
        String sitemapPath = this.sitemapPath;
        if (sitemapPath == null) {
            sitemapPath = "/sitemap.xmap";
        }
        if (!sitemapPath.startsWith("/")) {
            sitemapPath = "/" + sitemapPath;
        }
        return sitemapPath;
    }

    private void initializeBaseURL() throws InvalidBaseUrlException {
        try {
            String baseURL = this.getSitemapPath();
            baseURL = baseURL.substring(0, baseURL.lastIndexOf(47) + 1);
            this.baseURL = this.servletContext.getResource(baseURL);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Setting the baseURL to " + this.baseURL));
            }
        }
        catch (MalformedURLException e) {
            throw new InvalidBaseUrlException("An exception occurred while retrieving the base URL from the servlet context.", e);
        }
    }

    private void initializeInServletServiceFramework() {
        this.inServletServiceFramework = CallStack.getCurrentFrame() != null;
    }

    private void initializeSitemap() throws SitemapNotFoundException, SitemapInitializationException {
        URL url = null;
        SitemapBuilder sitemapBuilder = null;
        try {
            sitemapBuilder = (SitemapBuilder)this.beanFactory.getBean(SitemapBuilder.class.getName());
            url = this.servletContext.getResource(this.getSitemapPath());
        }
        catch (Exception e) {
            throw new SitemapInitializationException("Can't initialize sitemap.", e);
        }
        if (url == null) {
            String baseURL = this.getBaseURL().toExternalForm();
            if (baseURL.endsWith("/")) {
                baseURL = baseURL.substring(0, baseURL.length() - 1);
            }
            throw new SitemapNotFoundException("Can't find sitemap at " + baseURL + this.getSitemapPath());
        }
        this.sitemapNode = sitemapBuilder.build(url);
    }

    private void initializeVersionNumber() {
        Properties pomProperties = ResourceUtils.getPOMProperties((String)"org.apache.cocoon.servlet", (String)"cocoon-servlet");
        if (pomProperties == null) {
            return;
        }
        String servletModuleVersion = pomProperties.getProperty("version");
        if (servletModuleVersion != null) {
            this.version = servletModuleVersion;
        }
        if (this.version.endsWith("SNAPSHOT")) {
            String buildNumber;
            block6: {
                buildNumber = "";
                try {
                    String buildNumberAttr = ManifestUtils.getAttribute(this.getClass(), "Implementation-Build");
                    if (buildNumberAttr != null && !"".equals(buildNumberAttr) && !"na".equals(buildNumberAttr)) {
                        buildNumber = "/rev" + buildNumberAttr;
                    }
                }
                catch (IOException e) {
                    if (!this.logger.isDebugEnabled()) break block6;
                    this.logger.debug((Object)"Error while reading an attribute from the manifest.", (Throwable)e);
                }
            }
            this.version = this.version + buildNumber;
        }
    }

    private void invoke(String requestURI, Map<String, Object> parameters, OutputStream outputStream) {
        InvocationImpl invocation = (InvocationImpl)this.beanFactory.getBean(Invocation.class.getName());
        invocation.setBaseURL(this.getBaseURL());
        invocation.setRequestURI(requestURI);
        invocation.setParameters(parameters);
        invocation.setOutputStream(outputStream);
        invocation.setObjectModel(ObjectModelProvider.provide(parameters));
        this.sitemapNode.invoke((Invocation)invocation);
    }

    private void logRequest(HttpServletRequest request) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Performing " + request.getMethod().toUpperCase() + " request at " + request.getRequestURI()));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("The base URL for this request is " + this.getBaseURL()));
        }
    }

    public static Map<String, Object> prepareParameters(HttpServletRequest request, HttpServletResponse response, Settings settings, ServletContext servletContext) {
        if (request == null) {
            throw new NullPointerException("Request mustn't be null.");
        }
        if (response == null) {
            throw new NullPointerException("Response mustn't be null.");
        }
        if (servletContext == null) {
            throw new NullPointerException("ServletContext mustn't be null.");
        }
        Map<String, Object> parameters = RequestProcessor.getInvocationParameters(request);
        HttpContextHelper.storeRequest(request, parameters);
        HttpContextHelper.storeResponse(response, parameters);
        HttpContextHelper.storeServletContext(servletContext, parameters);
        if (settings != null) {
            SettingsHelper.storeSettings(settings, parameters);
        }
        return parameters;
    }

    private void sendSitemapResponse(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String mimeType;
        Settings settings = (Settings)this.beanFactory.getBean(Settings.class.getName());
        long ifModifiedSince = request.getDateHeader("If-Modified-Since");
        ResponseHeaderCollector.setIfLastModifiedSince(ifModifiedSince);
        String ifNoneMatch = request.getHeader("If-None-Match");
        ResponseHeaderCollector.setIfNoneMatch(ifNoneMatch);
        ResponseHeaderCollector.setRequestMethod(request.getMethod());
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
        this.invoke(this.calcSitemapRequestURI(request), RequestProcessor.prepareParameters(request, response, settings, this.servletContext), baos);
        int statusCode = ResponseHeaderCollector.getStatusCode();
        long lastModified = ResponseHeaderCollector.getLastModified();
        String etag = ResponseHeaderCollector.getETag();
        if (statusCode >= 200 && statusCode < 300) {
            if (etag != null && !"".equals(etag)) {
                response.setHeader("ETag", etag);
            }
            if (lastModified > -1L) {
                response.setDateHeader("Last-Modified", lastModified);
            }
        }
        if (!"false".equals(settings.getProperty("org.apache.cocoon.show-version"))) {
            response.setHeader("X-Cocoon-Version", this.version);
        }
        if ((mimeType = ResponseHeaderCollector.getMimeType()) == null || "".equals(mimeType) || "content/unknown".equals(mimeType)) {
            mimeType = this.servletContext.getMimeType(request.getRequestURI());
        }
        if (mimeType != null) {
            response.setContentType(mimeType);
        }
        if (!ResponseHeaderCollector.isModifiedResponse()) {
            response.setStatus(304);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Going to send NOT MODIFIED response: statusCode=" + statusCode + ", lastModified=" + lastModified));
            }
            return;
        }
        int contentLengh = baos.size();
        response.setContentLength(contentLengh);
        response.setStatus(statusCode);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Going to send " + request.getMethod().toUpperCase() + " response: mimeType=" + mimeType + ", contentLength=" + contentLengh + ", statusCode=" + statusCode + ", lastModified=" + lastModified));
        }
        if ("HEAD".equalsIgnoreCase(request.getMethod())) {
            return;
        }
        if (contentLengh > 0) {
            response.getOutputStream().write(baos.toByteArray());
        }
    }

    public static class SitemapNotFoundException
    extends RequestProcessorException {
        private static final long serialVersionUID = 1L;

        public SitemapNotFoundException(String message) {
            super(message);
        }
    }

    public static class SitemapInitializationException
    extends RequestProcessorException {
        private static final long serialVersionUID = 1L;

        public SitemapInitializationException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class RequestProcessorException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public RequestProcessorException(String message) {
            super(message);
        }

        public RequestProcessorException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class InvalidBaseUrlException
    extends RequestProcessorException {
        private static final long serialVersionUID = 1L;

        public InvalidBaseUrlException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

