/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servlet;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DebugFilter
implements Filter {
    private final Log logger = LogFactory.getLog(this.getClass());
    protected static final String lineSeparator = "\n";
    private volatile int activeRequestCount;

    public void init(FilterConfig config) throws ServletException {
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain filterChain) throws IOException, ServletException {
        if (!(req instanceof HttpServletRequest)) {
            filterChain.doFilter(req, res);
            return;
        }
        try {
            ++this.activeRequestCount;
            HttpServletRequest request = (HttpServletRequest)req;
            if (this.logger.isDebugEnabled()) {
                StringBuffer msg = new StringBuffer();
                msg.append("DEBUGGING INFORMATION:").append(lineSeparator);
                msg.append("REQUEST: ").append(request.getRequestURI()).append(lineSeparator).append(lineSeparator);
                msg.append("CONTEXT PATH: ").append(request.getContextPath()).append(lineSeparator);
                msg.append("SERVLET PATH: ").append(request.getServletPath()).append(lineSeparator);
                msg.append("PATH INFO: ").append(request.getPathInfo()).append(lineSeparator).append(lineSeparator);
                msg.append("REMOTE HOST: ").append(request.getRemoteHost()).append(lineSeparator);
                msg.append("REMOTE ADDRESS: ").append(request.getRemoteAddr()).append(lineSeparator);
                msg.append("REMOTE USER: ").append(request.getRemoteUser()).append(lineSeparator);
                msg.append("REQUEST SESSION ID: ").append(request.getRequestedSessionId()).append(lineSeparator);
                msg.append("REQUEST PREFERRED LOCALE: ").append(request.getLocale().toString()).append(lineSeparator);
                msg.append("SERVER HOST: ").append(request.getServerName()).append(lineSeparator);
                msg.append("SERVER PORT: ").append(request.getServerPort()).append(lineSeparator).append(lineSeparator);
                msg.append("METHOD: ").append(request.getMethod()).append(lineSeparator);
                msg.append("CONTENT LENGTH: ").append(request.getContentLength()).append(lineSeparator);
                msg.append("PROTOCOL: ").append(request.getProtocol()).append(lineSeparator);
                msg.append("SCHEME: ").append(request.getScheme()).append(lineSeparator);
                msg.append("AUTH TYPE: ").append(request.getAuthType()).append(lineSeparator).append(lineSeparator);
                msg.append("CURRENT ACTIVE REQUESTS: ").append(this.activeRequestCount).append(lineSeparator);
                Enumeration e = request.getParameterNames();
                msg.append("REQUEST PARAMETERS:").append(lineSeparator).append(lineSeparator);
                while (e.hasMoreElements()) {
                    String p = (String)e.nextElement();
                    msg.append("PARAM: '").append(p).append("' ").append("VALUES: '");
                    String[] params = request.getParameterValues(p);
                    for (int i = 0; i < params.length; ++i) {
                        msg.append("[" + params[i] + "]");
                        if (i == params.length - 1) continue;
                        msg.append(", ");
                    }
                    msg.append("'").append(lineSeparator);
                }
                Enumeration e2 = request.getHeaderNames();
                msg.append("HEADER PARAMETERS:").append(lineSeparator).append(lineSeparator);
                while (e2.hasMoreElements()) {
                    String p = (String)e2.nextElement();
                    msg.append("PARAM: '").append(p).append("' ").append("VALUES: '");
                    Enumeration e3 = request.getHeaders(p);
                    while (e3.hasMoreElements()) {
                        msg.append("[" + e3.nextElement() + "]");
                        if (!e3.hasMoreElements()) continue;
                        msg.append(", ");
                    }
                    msg.append("'").append(lineSeparator);
                }
                msg.append(lineSeparator).append("SESSION ATTRIBUTES:").append(lineSeparator).append(lineSeparator);
                HttpSession session = ((HttpServletRequest)req).getSession(false);
                if (session != null) {
                    HttpSession httpSession = session;
                    synchronized (httpSession) {
                        Enumeration se = session.getAttributeNames();
                        while (se.hasMoreElements()) {
                            String p = (String)se.nextElement();
                            msg.append("PARAM: '").append(p).append("' ").append("VALUE: '").append(session.getAttribute(p)).append("'").append(lineSeparator);
                        }
                    }
                }
                this.logger.debug((Object)msg.toString());
            }
            filterChain.doFilter((ServletRequest)request, res);
        }
        finally {
            --this.activeRequestCount;
        }
    }
}

