/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.stax.navigation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.cocoon.stax.navigation.MatchingType;
import org.apache.cocoon.stax.navigation.Navigator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FindStartElementNavigator
implements Navigator {
    private String name;
    private List<Attribute> attributes = new ArrayList<Attribute>();
    private boolean active;
    private MatchingType matchingType = MatchingType.StringMatch;

    public FindStartElementNavigator(String name) {
        this.name = name;
    }

    public FindStartElementNavigator(String name, List<Attribute> attributes) {
        this(name);
        if (attributes != null) {
            this.attributes = attributes;
        }
    }

    public FindStartElementNavigator(String name, Attribute ... attributes) {
        this(name);
        if (attributes != null) {
            this.attributes = new ArrayList<Attribute>(Arrays.asList(attributes));
        }
    }

    public FindStartElementNavigator(String name, MatchingType matchingType, List<Attribute> attributes) {
        this(name, attributes);
        this.matchingType = matchingType;
    }

    public FindStartElementNavigator(String name, MatchingType matchingType, Attribute ... attributes) {
        this(name, attributes);
        this.matchingType = matchingType;
    }

    @Override
    public boolean fulfillsCriteria(XMLEvent event) {
        if (event.isStartElement()) {
            StartElement element = (StartElement)event;
            boolean nameMatches = false;
            switch (this.matchingType) {
                case RegexMatch: {
                    nameMatches = Pattern.compile(this.name).matcher(element.getName().getLocalPart()).matches();
                    break;
                }
                default: {
                    nameMatches = element.getName().getLocalPart().equals(this.name);
                }
            }
            if (!nameMatches) {
                this.active = false;
                return this.active;
            }
            block6: for (Attribute attribute : this.attributes) {
                switch (this.matchingType) {
                    case RegexMatch: {
                        boolean elementMatches = false;
                        Pattern namePattern = Pattern.compile(attribute.getName().getLocalPart());
                        Pattern valuePattern = Pattern.compile(attribute.getValue());
                        Iterator<Attribute> elementAttributeIter = element.getAttributes();
                        while (elementAttributeIter.hasNext()) {
                            Attribute elementAttribute = elementAttributeIter.next();
                            Matcher nameMatcher = namePattern.matcher(elementAttribute.getName().getLocalPart());
                            Matcher valueMatcher = valuePattern.matcher(elementAttribute.getValue());
                            if (!nameMatcher.matches() || !valueMatcher.matches()) continue;
                            elementMatches = true;
                            break;
                        }
                        if (elementMatches) continue block6;
                        this.active = false;
                        return this.active;
                    }
                }
                Attribute foundAttribute = element.getAttributeByName(attribute.getName());
                if (foundAttribute != null && attribute.getValue().equals(foundAttribute.getValue())) continue;
                this.active = false;
                return this.active;
            }
            this.active = true;
            return this.active;
        }
        this.active = false;
        return this.active;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }
}

