/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.stax.navigation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.cocoon.stax.navigation.Navigator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindEndElementNavigator
implements Navigator {
    private String name;
    private List<Attribute> attributes = new ArrayList<Attribute>();
    private List<String> levelRememberer = new ArrayList<String>();
    private int count = 0;
    private boolean active;

    public FindEndElementNavigator(String name) {
        this.name = name;
    }

    public FindEndElementNavigator(String name, List<Attribute> attributes) {
        this.name = name;
        if (attributes != null) {
            this.attributes = attributes;
        }
    }

    public FindEndElementNavigator(String name, Attribute ... attributes) {
        this.name = name;
        if (attributes != null) {
            this.attributes = new ArrayList<Attribute>(Arrays.asList(attributes));
        }
    }

    @Override
    public boolean fulfillsCriteria(XMLEvent event) {
        EndElement element;
        if (event.isStartElement()) {
            StartElement element2 = (StartElement)event;
            if (!element2.getName().getLocalPart().equals(this.name)) {
                this.active = false;
                return this.active;
            }
            ++this.count;
            for (Attribute attribute : this.attributes) {
                if (attribute.getValue().equals(element2.getAttributeByName(attribute.getName()).getValue())) continue;
                this.active = false;
                return this.active;
            }
            this.levelRememberer.add(String.valueOf(this.count));
            this.active = false;
            return this.active;
        }
        if (event.isEndElement() && (element = (EndElement)event).getName().getLocalPart().equals(this.name) && this.count > 0) {
            if (this.levelRememberer.contains(String.valueOf(this.count))) {
                this.levelRememberer.remove(String.valueOf(this.count));
                --this.count;
                this.active = true;
                return this.active;
            }
            --this.count;
        }
        this.active = false;
        return this.active;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }
}

