/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.stax.navigation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.cocoon.stax.navigation.Navigator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindCorrespondingStartEndElementPairNavigator
implements Navigator {
    private String name;
    private List<Attribute> attributes = new ArrayList<Attribute>();
    private List<String> levelRememberer = new ArrayList<String>();
    private int count = 0;
    private boolean active;

    public FindCorrespondingStartEndElementPairNavigator(String name) {
        this.name = name;
    }

    public FindCorrespondingStartEndElementPairNavigator(String name, List<Attribute> attributes) {
        this.name = name;
        if (attributes != null) {
            this.attributes = attributes;
        }
    }

    public FindCorrespondingStartEndElementPairNavigator(String name, Attribute ... attributes) {
        this.name = name;
        if (attributes != null) {
            this.attributes = new ArrayList<Attribute>(Arrays.asList(attributes));
        }
    }

    @Override
    public boolean fulfillsCriteria(XMLEvent event) {
        if (event.isStartElement()) {
            StartElement element = (StartElement)event;
            if (!element.getName().getLocalPart().equals(this.name)) {
                this.active = false;
                return this.active;
            }
            ++this.count;
            for (Attribute attribute : this.attributes) {
                if (attribute.getValue().equals(element.getAttributeByName(attribute.getName()).getValue())) continue;
                this.active = false;
                return this.active;
            }
            this.levelRememberer.add(String.valueOf(this.count));
            this.active = true;
            return this.active;
        }
        if (event.isEndElement()) {
            EndElement element = (EndElement)event;
            if (!element.getName().getLocalPart().equals(this.name) || this.count <= 0) {
                this.active = false;
                return this.active;
            }
            if (this.levelRememberer.contains(String.valueOf(this.count))) {
                this.levelRememberer.remove(String.valueOf(this.count));
                --this.count;
                this.active = true;
                return this.active;
            }
            --this.count;
        }
        this.active = false;
        return this.active;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }
}

