/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.stax.converter.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.util.XMLEventConsumer;
import org.apache.cocoon.sax.SAXConsumer;
import org.apache.cocoon.stax.converter.util.SimpleNamespaceContext;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StAXEventContentHandler
extends DefaultHandler
implements SAXConsumer {
    private boolean isCDATA;
    private StringBuffer CDATABuffer;
    private SimpleNamespaceContext namespaces;
    private Locator docLocator;
    private XMLReporter reporter;
    private XMLEventConsumer consumer;
    private XMLEventFactory eventFactory;
    private List namespaceStack = new ArrayList();

    public StAXEventContentHandler() {
        this.eventFactory = XMLEventFactory.newInstance();
    }

    public StAXEventContentHandler(XMLEventConsumer consumer) {
        this.consumer = consumer;
        this.eventFactory = XMLEventFactory.newInstance();
    }

    public StAXEventContentHandler(XMLEventConsumer consumer, XMLEventFactory factory) {
        this.consumer = consumer;
        this.eventFactory = factory != null ? factory : XMLEventFactory.newInstance();
    }

    public XMLEventConsumer getEventConsumer() {
        return this.consumer;
    }

    public void setEventConsumer(XMLEventConsumer consumer) {
        this.consumer = consumer;
    }

    public XMLEventFactory getEventFactory() {
        return this.eventFactory;
    }

    public void setEventFactory(XMLEventFactory factory) {
        this.eventFactory = factory;
    }

    @Override
    public void startDocument() throws SAXException {
        this.namespaces = new SimpleNamespaceContext();
        this.namespaceStack.clear();
        this.eventFactory.setLocation(this.getCurrentLocation());
        try {
            this.consumer.add(this.eventFactory.createStartDocument());
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.eventFactory.setLocation(this.getCurrentLocation());
        try {
            this.consumer.add(this.eventFactory.createEndDocument());
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
        this.namespaces = null;
        this.namespaceStack.clear();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.namespaces = null;
        this.eventFactory.setLocation(this.getCurrentLocation());
        Collection[] events = new Collection[]{null, null};
        this.createStartEvents(attributes, events);
        this.namespaceStack.add(events[0]);
        try {
            String[] qname = new String[]{null, null};
            this.parseQName(qName, qname);
            this.consumer.add(this.eventFactory.createStartElement(qname[0], uri, qname[1], events[1].iterator(), events[0].iterator()));
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
        finally {
            super.startElement(uri, localName, qName, attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.namespaces = null;
        super.endElement(uri, localName, qName);
        this.eventFactory.setLocation(this.getCurrentLocation());
        String[] qname = new String[]{null, null};
        this.parseQName(qName, qname);
        Collection nsList = (Collection)this.namespaceStack.remove(this.namespaceStack.size() - 1);
        Iterator nsIter = nsList.iterator();
        try {
            this.consumer.add(this.eventFactory.createEndElement(qname[0], uri, qname[1], nsIter));
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        this.eventFactory.setLocation(this.getCurrentLocation());
        try {
            this.consumer.add(this.eventFactory.createComment(new String(ch, start, length)));
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        super.characters(ch, start, length);
        if (this.isCDATA) {
            this.CDATABuffer.append(ch, start, length);
        }
        try {
            if (!this.isCDATA) {
                this.eventFactory.setLocation(this.getCurrentLocation());
                this.consumer.add(this.eventFactory.createCharacters(new String(ch, start, length)));
            }
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        super.ignorableWhitespace(ch, start, length);
        this.characters(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        super.processingInstruction(target, data);
        try {
            this.consumer.add(this.eventFactory.createProcessingInstruction(target, data));
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    public void endCDATA() throws SAXException {
        this.eventFactory.setLocation(this.getCurrentLocation());
        try {
            this.consumer.add(this.eventFactory.createCData(this.CDATABuffer.toString()));
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
        this.isCDATA = false;
        this.CDATABuffer.setLength(0);
    }

    protected void createStartEvents(Attributes attributes, Collection[] events) {
        HashMap<String, Namespace> nsMap = null;
        ArrayList<Attribute> attrs = null;
        if (this.namespaces != null) {
            Iterator prefixes = this.namespaces.getDeclaredPrefixes();
            while (prefixes.hasNext()) {
                String prefix = (String)prefixes.next();
                String uri = this.namespaces.getNamespaceURI(prefix);
                Namespace ns = this.createNamespace(prefix, uri);
                if (nsMap == null) {
                    nsMap = new HashMap<String, Namespace>();
                }
                nsMap.put(prefix, ns);
            }
        }
        String[] qname = new String[]{null, null};
        int s = attributes.getLength();
        for (int i = 0; i < s; ++i) {
            this.parseQName(attributes.getQName(i), qname);
            String attrPrefix = qname[0];
            String attrLocal = qname[1];
            String attrQName = attributes.getQName(i);
            String attrValue = attributes.getValue(i);
            String attrURI = attributes.getURI(i);
            if ("xmlns".equals(attrQName) || "xmlns".equals(attrPrefix)) {
                if (nsMap.containsKey(attrPrefix)) continue;
                Namespace ns = this.createNamespace(attrPrefix, attrValue);
                if (nsMap == null) {
                    nsMap = new HashMap();
                }
                nsMap.put(attrPrefix, ns);
                continue;
            }
            Attribute attribute = attrPrefix.length() > 0 ? this.eventFactory.createAttribute(attrPrefix, attrURI, attrLocal, attrValue) : this.eventFactory.createAttribute(attrLocal, attrValue);
            if (attrs == null) {
                attrs = new ArrayList<Attribute>();
            }
            attrs.add(attribute);
        }
        events[0] = nsMap == null ? Collections.EMPTY_LIST : nsMap.values();
        events[1] = attrs == null ? Collections.EMPTY_LIST : attrs;
    }

    protected Namespace createNamespace(String prefix, String uri) {
        if (prefix == null || prefix.length() == 0) {
            return this.eventFactory.createNamespace(uri);
        }
        return this.eventFactory.createNamespace(prefix, uri);
    }

    public void setXMLReporter(XMLReporter reporter) {
        this.reporter = reporter;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.docLocator = locator;
    }

    public Location getCurrentLocation() {
        if (this.docLocator != null) {
            return new SAXLocation(this.docLocator);
        }
        return null;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.reportException("ERROR", e);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.reportException("FATAL", e);
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.reportException("WARNING", e);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (prefix == null) {
            prefix = "";
        } else if (prefix.equals("xml")) {
            return;
        }
        if (this.namespaces == null) {
            this.namespaces = new SimpleNamespaceContext();
        }
        this.namespaces.setPrefix(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        this.isCDATA = true;
        if (this.CDATABuffer == null) {
            this.CDATABuffer = new StringBuffer();
        } else {
            this.CDATABuffer.setLength(0);
        }
    }

    public void endDTD() throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
    }

    protected void reportException(String type, SAXException e) throws SAXException {
        if (this.reporter != null) {
            try {
                this.reporter.report(e.getMessage(), type, e, this.getCurrentLocation());
            }
            catch (XMLStreamException e1) {
                throw new SAXException(e1);
            }
        }
    }

    private void parseQName(String qName, String[] results) {
        String local;
        String prefix;
        int idx = qName.indexOf(58);
        if (idx >= 0) {
            prefix = qName.substring(0, idx);
            local = qName.substring(idx + 1);
        } else {
            prefix = "";
            local = qName;
        }
        results[0] = prefix;
        results[1] = local;
    }

    public void finish() {
    }

    public void setConfiguration(Map<String, ? extends Object> configuration) {
    }

    public void setup(Map<String, Object> parameters) {
    }

    private class SAXLocation
    implements Location {
        private int lineNumber;
        private int columnNumber;
        private String publicId;
        private String systemId;

        private SAXLocation(Locator locator) {
            this.lineNumber = locator.getLineNumber();
            this.columnNumber = locator.getColumnNumber();
            this.publicId = locator.getPublicId();
            this.systemId = locator.getSystemId();
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }

        public int getCharacterOffset() {
            return -1;
        }

        public String getPublicId() {
            return this.publicId;
        }

        public String getSystemId() {
            return this.systemId;
        }
    }
}

