/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.stax.component;

import java.io.OutputStream;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.cocoon.pipeline.ProcessingException;
import org.apache.cocoon.pipeline.SetupException;
import org.apache.cocoon.pipeline.component.AbstractPipelineComponent;
import org.apache.cocoon.pipeline.component.Finisher;
import org.apache.cocoon.stax.StAXConsumer;
import org.apache.cocoon.stax.StAXProducer;

public class XMLSerializer
extends AbstractPipelineComponent
implements StAXConsumer,
Finisher {
    private StAXProducer parent;
    private XMLEventWriter writer;

    public void setOutputStream(OutputStream outputStream) {
        try {
            this.writer = XMLOutputFactory.newInstance().createXMLEventWriter(outputStream, "UTF-8");
        }
        catch (XMLStreamException e) {
            throw new SetupException("Error during setup an XMLEventWriter on the outputStream", (Throwable)e);
        }
        catch (FactoryConfigurationError e) {
            throw new SetupException("Error during setup the XMLOutputFactory for creating an XMLEventWriter", (Throwable)e);
        }
    }

    public void initiatePullProcessing() {
        try {
            while (this.parent.hasNext()) {
                this.writer.add(this.parent.nextEvent());
            }
        }
        catch (XMLStreamException e) {
            throw new ProcessingException("Error during writing output elements.", (Throwable)e);
        }
        try {
            this.writer.flush();
        }
        catch (XMLStreamException e) {
            throw new ProcessingException("Finally cant flush the output stream.", (Throwable)e);
        }
    }

    public void setParent(StAXProducer parent) {
        this.parent = parent;
    }

    public String getContentType() {
        return null;
    }
}

