/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.stax.component;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import org.apache.cocoon.pipeline.ProcessingException;
import org.apache.cocoon.pipeline.util.StringRepresentation;
import org.apache.cocoon.stax.AbstractStAXTransformer;
import org.apache.cocoon.stax.StAXProducer;
import org.apache.cocoon.stax.component.XMLGenerator;
import org.apache.cocoon.stax.navigation.Navigator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncludeTransformer
extends AbstractStAXTransformer {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final String INCLUDE_NS = "http://apache.org/cocoon/3.0/include";
    private static final String INCLUDE_EL = "include";
    private static final String SRC_ATTR = "src";
    private static final QName INCLUDE_QNAME = new QName("http://apache.org/cocoon/3.0/include", "include");
    private URL baseUrl;
    private Navigator isIncludeEnd;
    private Navigator isIncludeStart = new Navigator(){
        private boolean active;

        public boolean fulfillsCriteria(XMLEvent event) {
            if (event.isStartElement()) {
                this.active = event.asStartElement().getName().equals(INCLUDE_QNAME);
                return this.active;
            }
            this.active = false;
            return this.active;
        }

        public boolean isActive() {
            return this.active;
        }
    };
    private StAXProducer includeDelegate;

    public IncludeTransformer() {
        this.isIncludeEnd = new Navigator(){
            private boolean active;

            public boolean fulfillsCriteria(XMLEvent event) {
                if (event.isEndElement()) {
                    this.active = event.asEndElement().getName().equals(INCLUDE_QNAME);
                    return this.active;
                }
                this.active = false;
                return this.active;
            }

            public boolean isActive() {
                return this.active;
            }
        };
    }

    @Override
    public void produceEvents() throws XMLStreamException {
        while (this.getParent().hasNext()) {
            XMLEvent event;
            if (this.includeDelegate == null) {
                event = this.getParent().nextEvent();
                if (this.isIncludeStart.fulfillsCriteria(event)) {
                    Attribute sourceAttribute = event.asStartElement().getAttributeByName(new QName(SRC_ATTR));
                    URL source = this.createSource(sourceAttribute.getValue());
                    try {
                        this.includeDelegate = new XMLGenerator(source.openConnection().getInputStream());
                        continue;
                    }
                    catch (IOException e) {
                        String message = "Can't read from URL " + sourceAttribute.getValue();
                        this.logger.error((Object)message, (Throwable)e);
                        throw new ProcessingException(message, (Throwable)e);
                    }
                }
                if (this.isIncludeEnd.fulfillsCriteria(event)) continue;
                this.addEventToQueue(event);
                return;
            }
            if (this.includeDelegate.hasNext()) {
                event = this.includeDelegate.nextEvent();
                if (event.isStartDocument() || event.isEndDocument()) continue;
                this.addEventToQueue(event);
                return;
            }
            this.includeDelegate = null;
        }
    }

    private URL createSource(String sourceAtt) {
        try {
            URL source = null;
            source = sourceAtt.contains(":") ? new URL(sourceAtt) : new URL(this.baseUrl, sourceAtt);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Including source: " + source));
            }
            return source;
        }
        catch (MalformedURLException e) {
            String message = "Can't parse URL " + sourceAtt;
            this.logger.error((Object)message, (Throwable)e);
            throw new ProcessingException(message, (Throwable)e);
        }
    }

    public void setConfiguration(Map<String, ? extends Object> configuration) {
        this.setBaseUrl((URL)configuration.get("baseUrl"));
    }

    public void setBaseUrl(URL baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String toString() {
        return StringRepresentation.buildString((Object)this, (String[])new String[]{"baseUrl=" + this.baseUrl});
    }
}

