/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.uima.metadatagenerator;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.ws.rs.core.MediaType;
import org.apache.clerezza.rdf.metadata.MetaDataGenerator;
import org.apache.clerezza.rdf.ontologies.DC;
import org.apache.clerezza.rdf.ontologies.DCTERMS;
import org.apache.clerezza.rdf.utils.GraphNode;
import org.apache.clerezza.uima.metadatagenerator.mediatype.MediaTypeTextExtractor;
import org.apache.clerezza.uima.metadatagenerator.mediatype.PlainTextExtractor;
import org.apache.clerezza.uima.metadatagenerator.mediatype.UnsupportedMediaTypeException;
import org.apache.clerezza.uima.utils.ExternalServicesFacade;
import org.apache.clerezza.uima.utils.UIMAServicesFacade;
import org.apache.clerezza.uima.utils.UIMAUtils;
import org.apache.uima.UIMAException;
import org.apache.uima.cas.FeatureStructure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UIMABaseMetadataGenerator
implements MetaDataGenerator {
    private static final Logger log = LoggerFactory.getLogger(UIMABaseMetadataGenerator.class);
    private UIMAServicesFacade facade;
    private Set<MediaTypeTextExtractor> textExtractors;

    public UIMABaseMetadataGenerator() {
        this.facade = new ExternalServicesFacade();
        this.textExtractors = new TreeSet<MediaTypeTextExtractor>();
    }

    public UIMABaseMetadataGenerator(ExternalServicesFacade facade) {
        this.facade = facade;
        this.textExtractors = new TreeSet<MediaTypeTextExtractor>();
    }

    public void generate(GraphNode node, byte[] data, MediaType mediaType) {
        if (this.textExtractors.isEmpty()) {
            this.initializeExtractors();
        }
        try {
            String text = this.getTextToAnalyze(data, mediaType);
            this.addLanguage(node, text);
            this.addCategory(node, text);
            this.addNamedEntities(node, text);
            this.addTags(node, text);
            log.info(node.toString() + " graph node enriched");
        }
        catch (Throwable e) {
            log.error("Unable to extract metadata due to " + e.toString());
        }
    }

    private void initializeExtractors() {
        this.textExtractors.add(new PlainTextExtractor());
    }

    private String getTextToAnalyze(byte[] data, MediaType mediaType) throws UnsupportedMediaTypeException {
        String text = null;
        for (MediaTypeTextExtractor textExtractor : this.textExtractors) {
            if (!textExtractor.supports(mediaType)) continue;
            text = textExtractor.extract(data);
            break;
        }
        if (text == null) {
            throw new UnsupportedMediaTypeException(mediaType);
        }
        return text;
    }

    private void addCategory(GraphNode node, String data) throws UIMAException {
        FeatureStructure categoryFS = this.facade.getCategory(data);
        String category = categoryFS.getStringValue(categoryFS.getType().getFeatureByBaseName("text"));
        node.addPropertyValue(DC.subject, (Object)category);
    }

    private void addLanguage(GraphNode node, String data) throws UIMAException {
        FeatureStructure languageFS = this.facade.getLanguage(data);
        String language = languageFS.getStringValue(languageFS.getType().getFeatureByBaseName("language"));
        node.addPropertyValue(DCTERMS.language, (Object)language);
    }

    private void addNamedEntities(GraphNode existingNode, String data) throws UIMAException {
        List namedEntities = this.facade.getNamedEntities(data);
        UIMAUtils.enhanceNode((GraphNode)existingNode, (List)namedEntities);
    }

    private void addTags(GraphNode existingNode, String data) throws UIMAException {
        List alchemyAPITags = this.facade.getTags(data);
        UIMAUtils.enhanceNode((GraphNode)existingNode, (List)alchemyAPITags);
    }
}

