/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.platform.graphprovider.content;

import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.clerezza.commons.rdf.Graph;
import org.apache.clerezza.commons.rdf.IRI;
import org.apache.clerezza.platform.Constants;
import org.apache.clerezza.rdf.core.access.NoSuchEntityException;
import org.apache.clerezza.rdf.core.access.TcManager;
import org.apache.clerezza.rdf.utils.UnionGraph;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.osgi.service.component.ComponentContext;

@Component
@Service(value={ContentGraphProvider.class})
public class ContentGraphProvider {
    @Property(name="additions", description="Contains additional Graphs that are added to the content graph for reading", value={"", ""})
    public static final String CONTENT_ADDITIONS = "additions";
    @Reference
    private TcManager tcManager;
    private IRI[] additions;
    private ReentrantReadWriteLock configLock = new ReentrantReadWriteLock();

    protected void activate(ComponentContext context) {
        try {
            this.tcManager.getGraph(Constants.CONTENT_GRAPH_URI);
        }
        catch (NoSuchEntityException nsee) {
            this.tcManager.createGraph(Constants.CONTENT_GRAPH_URI);
        }
        String[] additionUriStrings = (String[])context.getProperties().get(CONTENT_ADDITIONS);
        this.additions = new IRI[additionUriStrings.length];
        for (int i = 0; i < additionUriStrings.length; ++i) {
            this.additions[i] = new IRI(additionUriStrings[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Graph getContentGraph() {
        this.configLock.readLock().lock();
        try {
            Graph[] united = new Graph[this.additions.length + 1];
            int i = 0;
            united[i++] = this.tcManager.getGraph(Constants.CONTENT_GRAPH_URI);
            for (IRI uriRef : this.additions) {
                united[i++] = this.tcManager.getGraph(uriRef);
            }
            UnionGraph unionGraph = new UnionGraph(united);
            return unionGraph;
        }
        finally {
            this.configLock.readLock().unlock();
        }
    }

    public void addTemporaryAdditionGraph(IRI graphName) {
        this.configLock.writeLock().lock();
        try {
            HashSet<IRI> additionsSet = new HashSet<IRI>(Arrays.asList(this.additions));
            additionsSet.add(graphName);
            this.additions = additionsSet.toArray(new IRI[additionsSet.size()]);
        }
        finally {
            this.configLock.writeLock().unlock();
        }
    }

    public void removeTemporaryAdditionGraph(IRI graphName) {
        this.configLock.writeLock().lock();
        try {
            HashSet<IRI> additionsSet = new HashSet<IRI>(Arrays.asList(this.additions));
            additionsSet.remove(graphName);
            this.additions = additionsSet.toArray(new IRI[additionsSet.size()]);
        }
        finally {
            this.configLock.writeLock().unlock();
        }
    }

    protected void bindTcManager(TcManager tcManager) {
        this.tcManager = tcManager;
    }

    protected void unbindTcManager(TcManager tcManager) {
        if (this.tcManager == tcManager) {
            this.tcManager = null;
        }
    }
}

