/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.specexamples;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.chemistry.opencmis.client.bindings.CmisBindingFactory;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.CmisExtensionElement;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyId;
import org.apache.chemistry.opencmis.commons.data.PropertyString;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.BindingsObjectFactoryImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.CmisExtensionElementImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ExtensionDataImpl;
import org.apache.chemistry.opencmis.commons.spi.AclService;
import org.apache.chemistry.opencmis.commons.spi.BindingsObjectFactory;
import org.apache.chemistry.opencmis.commons.spi.CmisBinding;
import org.apache.chemistry.opencmis.commons.spi.DiscoveryService;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.commons.spi.MultiFilingService;
import org.apache.chemistry.opencmis.commons.spi.NavigationService;
import org.apache.chemistry.opencmis.commons.spi.ObjectService;
import org.apache.chemistry.opencmis.commons.spi.RepositoryService;
import org.apache.chemistry.opencmis.commons.spi.VersioningService;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Main {
    private static final Log LOG = LogFactory.getLog((String)Main.class.getName());
    private static final BigInteger TYPE_DEPTH_ALL = BigInteger.valueOf(-1L);
    private static final BigInteger MAX_ITEMS = null;
    private static final BigInteger SKIP_COUNT = BigInteger.valueOf(0L);
    private static final String TOPLEVEL_TYPE = "DocumentTopLevel";
    private static final String VERSIONED_TYPE = "VersionableType";
    private static final String VERSIONED_PROP = "VersionedStringProp";
    private static String LOGDIR = System.getProperty("java.io.tmpdir");
    private String targetDir = System.getProperty("java.io.tmpdir");
    private BindingsObjectFactory objFactory = new BindingsObjectFactoryImpl();
    private BindingType bindingType;
    private String rootFolderId;
    private String repositoryId;
    private ObjectService objSvc;
    private NavigationService navSvc;
    private RepositoryService repSvc;
    private VersioningService verSvc;
    private MultiFilingService multiSvc;
    private DiscoveryService discSvc;
    private AclService aclSvc;
    private static final String[] URLS = new String[]{"http://localhost:8080/inmemory/atom", "http://localhost:8080/inmemory/services", "http://localhost:8080/inmemory/browser"};
    private static final BindingType[] BINDINGS = new BindingType[]{BindingType.ATOMPUB, BindingType.WEBSERVICES, BindingType.BROWSER};

    public void runAllBindings() {
        for (int i = 0; i < BINDINGS.length; ++i) {
            this.bindingType = BINDINGS[i];
            this.init(URLS[i], BINDINGS[i]);
            this.run();
        }
    }

    public void run() {
        LOG.debug((Object)("Generating spec examples for Binding: " + this.bindingType.value()));
        this.getRepositories();
        this.repositoryId = "A1";
        this.getRepositoryInfo();
        this.getTypeDefinition("cmis:folder");
        String docId = this.getTestDocId();
        String folderId = this.getTestFolderId();
        this.getTypeChildren(TOPLEVEL_TYPE);
        this.getChildren(folderId);
        this.getDescendants(folderId);
        this.getObject(docId);
        this.getAcl(docId);
        String id1 = this.createDocument("SampleDocument", TOPLEVEL_TYPE, this.rootFolderId, VersioningState.NONE);
        this.updateProperties(id1, "cmis:name", "RenamedDocument");
        this.getAllowableActions(id1);
        this.deleteObject(id1);
        this.doQuery();
        String id2 = this.prepareVersionSeries("VersionedDocument", VERSIONED_TYPE, this.rootFolderId);
        this.checkOut(id2);
        this.checkIn(id2, true, "final version in series");
        this.getAllVersions(id2);
        String[] ids = new String[]{id2};
        this.cleanup(ids);
        String[] dirs = new String[]{BindingType.ATOMPUB.value(), BindingType.WEBSERVICES.value(), BindingType.BROWSER.value()};
        this.createZipFile("CMIS-Spec-Examples.zip", dirs);
    }

    private void init(String url, BindingType bindingType) {
        LOG.debug((Object)"Initializing connection to InMemory server: ");
        LOG.debug((Object)("   Binding: " + bindingType.value()));
        LOG.debug((Object)("   URL: " + url));
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("org.apache.chemistry.opencmis.user", "admin");
        parameters.put("org.apache.chemistry.opencmis.password", "admin");
        parameters.put("org.apache.chemistry.opencmis.binding.spi.type", bindingType.value());
        CmisBindingFactory factory = CmisBindingFactory.newInstance();
        CmisBinding binding = null;
        if (bindingType == BindingType.ATOMPUB) {
            parameters.put("org.apache.chemistry.opencmis.binding.atompub.url", url);
            binding = factory.createCmisAtomPubBinding(parameters);
        } else if (bindingType == BindingType.WEBSERVICES) {
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.ACLService", url + "/ACLService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.DiscoveryService", url + "/DiscoveryService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.MultiFilingService", url + "/MultiFilingService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.NavigationService", url + "/NavigationService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.ObjectService", url + "/ObjectService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.PolicyService", url + "/PolicyService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.RelationshipService", url + "/RelatinshipService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.RepositoryService", url + "/RepositoryService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.VersioningService", url + "/VersioningService?wsdl");
            binding = factory.createCmisWebServicesBinding(parameters);
        } else if (bindingType == BindingType.BROWSER) {
            parameters.put("org.apache.chemistry.opencmis.binding.browser.url", url);
            binding = factory.createCmisBrowserBinding(parameters);
        } else {
            LOG.error((Object)("Unknown binding type: " + bindingType.value()));
            return;
        }
        this.objFactory = binding.getObjectFactory();
        this.repSvc = binding.getRepositoryService();
        this.objSvc = binding.getObjectService();
        this.navSvc = binding.getNavigationService();
        this.verSvc = binding.getVersioningService();
        this.multiSvc = binding.getMultiFilingService();
        this.discSvc = binding.getDiscoveryService();
        this.aclSvc = binding.getAclService();
        this.targetDir = bindingType.value();
        File in = new File(this.targetDir);
        boolean ok = in.mkdir();
        LOG.debug((Object)("creating target directory for files: " + ok));
        LOG.debug((Object)"Initializing done. ");
    }

    private void getRepositories() {
        LOG.debug((Object)"getRepositories()");
        List repositories = this.repSvc.getRepositoryInfos(null);
        this.repositoryId = ((RepositoryInfo)repositories.get(0)).getId();
        this.renameFiles("getRepositoryInfos");
        LOG.debug((Object)"getRepositoryInfo() done.");
    }

    private void getRepositoryInfo() {
        LOG.debug((Object)("getting repository info for repository " + this.repositoryId));
        RepositoryInfo repoInfo = this.repSvc.getRepositoryInfo(this.repositoryId, null);
        if (this.bindingType.equals((Object)BindingType.BROWSER)) {
            ExtensionDataImpl dummyExt = new ExtensionDataImpl();
            ArrayList<CmisExtensionElement> extList = new ArrayList<CmisExtensionElement>(){
                {
                    this.add(new CmisExtensionElementImpl("foo", "foo", null, "bar"));
                }
            };
            dummyExt.setExtensions((List)extList);
            repoInfo = this.repSvc.getRepositoryInfo(this.repositoryId, (ExtensionsData)dummyExt);
        }
        LOG.debug((Object)("repository id is: " + repoInfo.getId()));
        this.rootFolderId = repoInfo.getRootFolderId();
        LOG.debug((Object)("root folder id is: " + repoInfo.getRootFolderId()));
        this.renameFiles("getRepositoryInfo");
        LOG.debug((Object)"getRepositoryInfo() done.");
    }

    private void getObject(String objectId) {
        LOG.debug((Object)("getObject " + objectId));
        this.objSvc.getObject(this.repositoryId, objectId, "*", Boolean.valueOf(true), IncludeRelationships.NONE, null, Boolean.valueOf(false), Boolean.valueOf(true), null);
        this.renameFiles("getObject");
        LOG.debug((Object)"getObject() done.");
    }

    private void getChildren(String folderId) {
        LOG.debug((Object)("getChildren " + folderId));
        this.navSvc.getChildren(this.repositoryId, folderId, "*", null, Boolean.valueOf(true), IncludeRelationships.NONE, null, Boolean.valueOf(true), MAX_ITEMS, SKIP_COUNT, null);
        this.renameFiles("getChildren");
        LOG.debug((Object)"getChildren() done.");
    }

    private void getDescendants(String folderId) {
        BigInteger DEPTH = BigInteger.valueOf(3L);
        LOG.debug((Object)("getDescendants " + folderId));
        this.navSvc.getDescendants(this.repositoryId, folderId, DEPTH, "*", Boolean.valueOf(true), IncludeRelationships.NONE, null, Boolean.valueOf(true), null);
        this.renameFiles("getDescendants");
        LOG.debug((Object)"getDescendants() done.");
    }

    private void doQuery() {
        LOG.debug((Object)"doQuery ");
        String statement = "SELECT * from cmis:document WHERE IN_FOLDER('" + this.rootFolderId + "')";
        this.discSvc.query(this.repositoryId, statement, Boolean.valueOf(false), Boolean.valueOf(true), IncludeRelationships.NONE, null, MAX_ITEMS, SKIP_COUNT, null);
        this.renameFiles("doQuery");
        LOG.debug((Object)"doQuery() done.");
    }

    private void getTypeChildren(String typeId) {
        LOG.debug((Object)("getTypeChildren " + typeId));
        this.repSvc.getTypeChildren(this.repositoryId, typeId, Boolean.valueOf(true), MAX_ITEMS, SKIP_COUNT, null);
        this.renameFiles("getTypeChildren");
        LOG.debug((Object)"getTypeChildren() done.");
    }

    private String createDocument(String name, String typeId, String folderId, VersioningState versioningState) {
        LOG.debug((Object)("createDocument " + typeId));
        String id = this.createDocumentIntern(name, typeId, folderId, versioningState);
        this.renameFiles("createDocument");
        LOG.debug((Object)"createDocument() done.");
        return id;
    }

    private String createDocumentIntern(String name, String typeId, String folderId, VersioningState versioningState) {
        ContentStream contentStream = null;
        List policies = null;
        Acl addACEs = null;
        Acl removeACEs = null;
        ExtensionsData extension = null;
        ArrayList<PropertyId> properties = new ArrayList<PropertyId>();
        properties.add(this.objFactory.createPropertyIdData("cmis:name", name));
        properties.add(this.objFactory.createPropertyIdData("cmis:objectTypeId", typeId));
        Properties props = this.objFactory.createPropertiesData(properties);
        contentStream = this.createContent();
        String id = null;
        id = this.objSvc.createDocument(this.repositoryId, props, folderId, contentStream, versioningState, policies, addACEs, removeACEs, extension);
        return id;
    }

    private ContentStream createContent() {
        ContentStreamImpl content = new ContentStreamImpl();
        content.setFileName("data.txt");
        content.setMimeType("text/plain");
        int len = 32768;
        byte[] b = new byte[]{97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 12, 10, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 12, 10};
        ByteArrayOutputStream ba = new ByteArrayOutputStream(len);
        try {
            for (int i = 0; i < 1024; ++i) {
                ba.write(b);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to fill content stream with data", e);
        }
        content.setStream((InputStream)new ByteArrayInputStream(ba.toByteArray()));
        content.setLength(BigInteger.valueOf(len));
        return content;
    }

    private void updateProperties(String id, String propertyId, String propertyValue) {
        LOG.debug((Object)("updateProperties " + id));
        ArrayList<PropertyString> properties = new ArrayList<PropertyString>();
        properties.add(this.objFactory.createPropertyStringData(propertyId, propertyValue));
        Properties newProps = this.objFactory.createPropertiesData(properties);
        Holder idHolder = new Holder((Object)id);
        Holder changeTokenHolder = new Holder();
        this.objSvc.updateProperties(this.repositoryId, idHolder, changeTokenHolder, newProps, null);
        this.renameFiles("updateProperties");
        LOG.debug((Object)"updateProperties() done.");
    }

    private void deleteObject(String id) {
        LOG.debug((Object)("deleteObject " + id));
        this.objSvc.deleteObject(this.repositoryId, id, Boolean.valueOf(true), null);
        this.renameFiles("deleteObject");
        LOG.debug((Object)"deleteObject() done.");
    }

    private void cleanup(String[] ids) {
        LOG.debug((Object)"cleaning up...");
        for (String id : ids) {
            LOG.debug((Object)("deleteing object " + id));
            this.objSvc.deleteObject(this.repositoryId, id, Boolean.valueOf(true), null);
        }
        LOG.debug((Object)"... cleaning up done");
    }

    private String getTestDocId() {
        return this.getTestId(BaseTypeId.CMIS_DOCUMENT);
    }

    private String getTestFolderId() {
        return this.getTestId(BaseTypeId.CMIS_FOLDER);
    }

    private String getTestId(BaseTypeId baseTypeId) {
        LOG.debug((Object)"getTestDocId()");
        ObjectInFolderList result = this.navSvc.getChildren(this.repositoryId, this.rootFolderId, "*", null, Boolean.valueOf(false), IncludeRelationships.NONE, null, Boolean.valueOf(true), MAX_ITEMS, SKIP_COUNT, null);
        List children = result.getObjects();
        LOG.debug((Object)(" found " + children.size() + " folders in getChildren()"));
        for (ObjectInFolderData child : children) {
            if (!baseTypeId.equals((Object)child.getObject().getBaseTypeId())) continue;
            return child.getObject().getId();
        }
        return null;
    }

    private String prepareVersionSeries(String name, String typeId, String folderId) {
        String id = this.createDocumentIntern(name, typeId, folderId, VersioningState.MAJOR);
        Holder contentCopied = new Holder();
        Holder idHolder = new Holder((Object)id);
        this.verSvc.checkOut(this.repositoryId, idHolder, null, contentCopied);
        String checkinComment = "Checkin V2.0";
        this.verSvc.checkIn(this.repositoryId, idHolder, Boolean.valueOf(true), null, null, checkinComment, null, null, null, null);
        this.verSvc.checkOut(this.repositoryId, idHolder, null, contentCopied);
        checkinComment = "Checkin V2.1";
        this.verSvc.checkIn(this.repositoryId, idHolder, Boolean.valueOf(false), null, null, checkinComment, null, null, null, null);
        return (String)idHolder.getValue();
    }

    private void checkOut(String id) {
        LOG.debug((Object)"checkOut()");
        Holder idHolder = new Holder((Object)id);
        Holder contentCopied = new Holder((Object)true);
        this.verSvc.checkOut(this.repositoryId, idHolder, null, contentCopied);
        this.renameFiles("checkOut");
        LOG.debug((Object)"checkOut done.");
    }

    private void checkIn(String id, boolean major, String checkinComment) {
        LOG.debug((Object)"checkIn()");
        ArrayList<PropertyString> properties = new ArrayList<PropertyString>();
        properties.add(this.objFactory.createPropertyStringData(VERSIONED_PROP, "updated value"));
        Properties newProps = this.objFactory.createPropertiesData(properties);
        Holder idHolder = new Holder((Object)id);
        this.verSvc.checkIn(this.repositoryId, idHolder, Boolean.valueOf(major), newProps, null, checkinComment, null, null, null, null);
        this.renameFiles("checkIn");
        LOG.debug((Object)"checkIn done.");
    }

    private void getAllVersions(String id) {
        LOG.debug((Object)"getAllVersions()");
        this.verSvc.getAllVersions(this.repositoryId, id, id, "*", Boolean.valueOf(false), null);
        this.renameFiles("getAllVersions");
        LOG.debug((Object)"getAllVersions done.");
    }

    private void getAcl(String objectId) {
        LOG.debug((Object)("getting Acl() " + objectId));
        Acl oldAcl = this.aclSvc.getAcl(this.repositoryId, objectId, Boolean.valueOf(true), null);
        ArrayList<Ace> aces = new ArrayList<Ace>();
        aces.add(this.objFactory.createAccessControlEntry("Alice", Collections.singletonList("cmis:read")));
        aces.add(this.objFactory.createAccessControlEntry("Bob", Collections.singletonList("cmis:write")));
        aces.add(this.objFactory.createAccessControlEntry("admin", Collections.singletonList("cmis:all")));
        Acl acl = this.objFactory.createAccessControlList(aces);
        this.aclSvc.applyAcl(this.repositoryId, objectId, acl, oldAcl, AclPropagation.OBJECTONLY, null);
        this.aclSvc.getAcl(this.repositoryId, objectId, Boolean.valueOf(true), null);
        this.renameFiles("getAcl");
        LOG.debug((Object)"getting Acl() done.");
    }

    private void getTypeDefinition(String typeId) {
        LOG.debug((Object)("getTypeDefinition " + typeId));
        this.repSvc.getTypeDefinition(this.repositoryId, typeId, null);
        this.renameFiles("getTypeDefinition");
        LOG.debug((Object)"getTypeDefinition() done.");
    }

    private void getTypeDescendants(String typeId) {
        LOG.debug((Object)("getTypeDescendants " + typeId));
        this.repSvc.getTypeDescendants(this.repositoryId, typeId, TYPE_DEPTH_ALL, Boolean.valueOf(true), null);
        this.renameFiles("getTypeDescendants");
        LOG.debug((Object)"getTypeDescendants() done.");
    }

    private void getAllowableActions(String objectId) {
        LOG.debug((Object)("getAllowableActions " + objectId));
        this.objSvc.getAllowableActions(this.repositoryId, objectId, null);
        this.renameFiles("getAllowableActions");
        LOG.debug((Object)"getAllowableActions() done.");
    }

    private void renameFiles(String name) {
        boolean ok;
        String fileNameInReq = Main.findLastFile(LOGDIR, "*-request.log");
        String fileNameInResp = Main.findLastFile(LOGDIR, "*-response.log");
        if (null == fileNameInReq) {
            LOG.error((Object)("Failed to find captured request file for " + name));
            return;
        }
        if (null == fileNameInResp) {
            LOG.error((Object)("Failed to find captured response file for " + name));
            return;
        }
        File in = new File(fileNameInReq);
        File out = new File(this.targetDir + File.separator + name + "-request.log");
        if (out.exists()) {
            out.delete();
        }
        if (ok = in.renameTo(out)) {
            LOG.debug((Object)("Renaming file " + in.getAbsolutePath() + " to " + out.getAbsolutePath() + " succeeded."));
        } else {
            LOG.warn((Object)("Renaming file " + in.getAbsolutePath() + " to " + out.getAbsolutePath() + " failed."));
        }
        in = new File(fileNameInResp);
        out = new File(this.targetDir + File.separator + name + "-response.log");
        if (out.exists()) {
            out.delete();
        }
        if (ok = in.renameTo(out)) {
            LOG.debug((Object)("Renaming file " + in.getAbsolutePath() + "to " + out.getAbsolutePath() + " succeeded."));
        } else {
            LOG.warn((Object)("Renaming file " + in.getAbsolutePath() + " to " + out.getAbsolutePath() + " failed."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createZipFile(String zipFileName, String[] dirs) {
        File out = new File(zipFileName);
        if (out.exists()) {
            out.delete();
        }
        FileOutputStream fout = null;
        ZipOutputStream zout = null;
        try {
            fout = new FileOutputStream(zipFileName);
            zout = new ZipOutputStream(fout);
            for (String dir : dirs) {
                File dirToZip = new File(dir);
                Main.addDirectory(zout, dir, dirToZip);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Creating ZIP file failed: " + e));
        }
        finally {
            try {
                if (zout != null) {
                    zout.close();
                }
                if (fout != null) {
                    fout.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)e);
            }
        }
    }

    private static void addDirectory(ZipOutputStream zout, String prefix, File sourceDir) throws IOException {
        File[] files = sourceDir.listFiles();
        LOG.debug((Object)("Create Zip, adding directory " + sourceDir.getName()));
        if (null != files) {
            for (int i = 0; i < files.length; ++i) {
                int length;
                if (files[i].isDirectory()) {
                    Main.addDirectory(zout, prefix + File.separator + files[i].getName(), files[i]);
                    continue;
                }
                LOG.debug((Object)("Create Zip, adding file " + files[i].getName()));
                byte[] buffer = new byte[65536];
                FileInputStream fin = new FileInputStream(files[i]);
                String zipEntryName = prefix + File.separator + files[i].getName();
                LOG.debug((Object)("   adding entry " + zipEntryName));
                zout.putNextEntry(new ZipEntry(zipEntryName));
                while ((length = fin.read(buffer)) > 0) {
                    zout.write(buffer, 0, length);
                }
                zout.closeEntry();
                fin.close();
            }
        }
    }

    public static void clean() {
        LOG.debug((Object)"Cleaning generated and captured request and response logs...");
        Main.cleanFilesWithFilter(LOGDIR, "*-request.log");
        Main.cleanFilesWithFilter(LOGDIR, "*-response.log");
        for (int i = 0; i < BINDINGS.length; ++i) {
            String dir = BINDINGS[i].value();
            Main.cleanFilesWithFilter(dir, "*-request.log");
            Main.cleanFilesWithFilter(dir, "*-response.log");
            File dirToDelete = new File(dir);
            boolean ok = dirToDelete.delete();
            if (ok) {
                LOG.debug((Object)("Deleting dir " + dirToDelete.getAbsolutePath() + " succeeded."));
                continue;
            }
            LOG.warn((Object)("Deleting dir " + dirToDelete.getAbsolutePath() + " failed."));
        }
        LOG.debug((Object)"... done.");
    }

    private static void cleanFilesWithFilter(String directoryPath, String wildcardFilter) {
        File dir = new File(directoryPath);
        WildcardFileFilter fileFilter = new WildcardFileFilter(wildcardFilter);
        File[] files = dir.listFiles((FileFilter)fileFilter);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                boolean ok = files[i].delete();
                LOG.debug((Object)("Deleting file: " + files[i] + ", success: " + ok));
            }
        }
    }

    private static String findLastFile(String directoryPath, String wildcardFilter) {
        File dir = new File(directoryPath);
        WildcardFileFilter fileFilter = new WildcardFileFilter(wildcardFilter);
        File[] files = dir.listFiles((FileFilter)fileFilter);
        if (files.length == 0) {
            return null;
        }
        return files[files.length - 1].getAbsolutePath();
    }

    public static void main(String[] args) {
        if (args.length > 0 && args[0].equals("-clean")) {
            LOG.debug((Object)"Cleaning up generated files...");
            Main.clean();
            LOG.debug((Object)"... cleaning up done.");
        } else {
            LOG.debug((Object)"Starting generating spec examples...");
            Main main = new Main();
            main.runAllBindings();
            LOG.debug((Object)"... finished generating spec examples.");
        }
    }
}

