/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.chemistry.opencmis.client.mapper.MapperException;
import org.apache.chemistry.opencmis.client.parser.AbstractMetadataParser;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.DefaultHandler;

public class MetadataParserTika
extends AbstractMetadataParser {
    private static final Log LOG = LogFactory.getLog((String)MetadataParserTika.class.getName());

    public void extractMetadata(File f, TypeDefinition td) throws MapperException {
        try {
            FileInputStream stream = new FileInputStream(f);
            Metadata metadata = new Metadata();
            DefaultHandler handler = new DefaultHandler();
            AutoDetectParser parser = new AutoDetectParser();
            ParseContext context = new ParseContext();
            parser.parse((InputStream)stream, (ContentHandler)handler, metadata, context);
            this.reset();
            for (String key : metadata.names()) {
                String propertyId;
                String val = metadata.get(key);
                LOG.debug((Object)("Found metadata '" + key + "': " + val));
                if (null == this.cmisProperties || null == (propertyId = this.mapper.getMappedPropertyId(key)) || null == val) continue;
                if (td != null) {
                    PropertyDefinition propDef = (PropertyDefinition)td.getPropertyDefinitions().get(propertyId);
                    if (null == propDef) {
                        throw new MapperException("Mapping error: unknown property " + propertyId + " in type definition " + td.getId());
                    }
                    PropertyType propertyType = propDef.getPropertyType();
                    Object convVal = this.mapper.convertValue(propertyId, propDef, val);
                    if (null == convVal) continue;
                    this.cmisProperties.put(propertyId, convVal);
                    continue;
                }
                this.cmisProperties.put(propertyId, val);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
            throw new MapperException("Extracting metadata failed for file " + f.getAbsolutePath(), e);
        }
    }

    public void listMetadata(File f) throws MapperException {
        try {
            FileInputStream stream = new FileInputStream(f);
            Metadata metadata = new Metadata();
            DefaultHandler handler = new DefaultHandler();
            AutoDetectParser parser = new AutoDetectParser();
            ParseContext context = new ParseContext();
            parser.parse((InputStream)stream, (ContentHandler)handler, metadata, context);
            for (String key : metadata.names()) {
                String val = metadata.get(key);
                LOG.info((Object)("Found metadata '" + key + "': " + val));
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
            throw new MapperException("Extracting metadata failed, file not found: " + f.getAbsolutePath(), e);
        }
    }
}

