/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.parser;

import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.Tag;
import java.io.File;
import java.util.Iterator;
import java.util.Map;
import org.apache.chemistry.opencmis.client.mapper.MapperException;
import org.apache.chemistry.opencmis.client.mapper.PropertyMapperExif;
import org.apache.chemistry.opencmis.client.parser.AbstractMetadataParser;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MetadataParserExif
extends AbstractMetadataParser {
    private static final Log LOG = LogFactory.getLog((String)MetadataParserExif.class.getName());

    public void extractMetadata(File f, TypeDefinition td) throws MapperException {
        this.reset();
        try {
            Metadata metadata = ImageMetadataReader.readMetadata((File)f);
            Iterator it = metadata.getDirectoryIterator();
            while (it.hasNext()) {
                Directory directory = (Directory)it.next();
                Iterator tagIt = directory.getTagIterator();
                while (tagIt.hasNext()) {
                    Tag tag = (Tag)tagIt.next();
                    Object o = directory.getObject(tag.getTagType());
                    LOG.debug((Object)("Tag: " + tag + ", value: " + o + ", class: " + o.getClass() + ", tag type: " + tag.getTagType() + ", hex-value: " + tag.getTagTypeHex()));
                    if (null == this.cmisProperties) continue;
                    ((PropertyMapperExif)this.mapper).mapTagAndConvert(directory, tag, td);
                }
            }
            Map<String, Object> props = ((PropertyMapperExif)this.mapper).getMappedProperties();
            this.cmisProperties.putAll(props);
        }
        catch (ImageProcessingException e) {
            LOG.error((Object)e);
        }
    }
}

