/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.mapper;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.chemistry.opencmis.client.mapper.MapperException;
import org.apache.chemistry.opencmis.client.mapper.PropertyMapper;
import org.apache.chemistry.opencmis.client.mapper.PropertyMapperTika;
import org.apache.chemistry.opencmis.client.parser.MetadataParser;
import org.apache.chemistry.opencmis.client.parser.MetadataParserTika;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Configurator {
    private static final Log LOG = LogFactory.getLog((String)Configurator.class.getName());
    private static Configurator INSTANCE;
    static final String PREFIX = "mapping.contentType";
    private Properties properties;
    private Map<String, PropertyMapper> contentTypeMapperMap = new HashMap<String, PropertyMapper>();
    private Map<String, MetadataParser> parserMap = new HashMap<String, MetadataParser>();
    private String defaultDocumentType;
    private String defaultFolderType;

    public static Configurator getInstance() {
        if (null == INSTANCE) {
            INSTANCE = new Configurator();
        }
        return INSTANCE;
    }

    private Configurator() {
        this.loadProperties();
        this.loadDefaults();
        this.buildMapperMap();
        this.createParsers();
    }

    Configurator(Properties props) {
        this.properties = props;
    }

    public PropertyMapper getPropertyMapper(String contentType) {
        MetadataParser parser = this.getParser(contentType);
        return parser.getMapper();
    }

    public MetadataParser getParser(String contentType) {
        MetadataParser parser = this.parserMap.get(contentType);
        if (null == parser) {
            String genericContentType = contentType.substring(0, contentType.indexOf(47)) + "/*";
            for (String key : this.parserMap.keySet()) {
                if (!key.equals(genericContentType)) continue;
                return this.parserMap.get(key);
            }
        }
        return parser;
    }

    private void loadProperties() {
        InputStream in = Configurator.class.getResourceAsStream("/mapping.properties");
        if (in != null) {
            this.properties = new Properties();
            try {
                this.properties.load(in);
            }
            catch (IOException e) {
                LOG.error((Object)e);
                e.printStackTrace();
                throw new MapperException("Could not load file mapping.properties as resource", e);
            }
        }
    }

    private void loadDefaults() {
        this.defaultDocumentType = this.properties.getProperty("mapping.contentType.default.document");
        if (null == this.defaultDocumentType) {
            this.defaultDocumentType = "cmis:document";
        }
        this.defaultFolderType = this.properties.getProperty("mapping.contentType.default.folder");
        if (null == this.defaultFolderType) {
            this.defaultFolderType = "cmis:folder";
        }
    }

    public String getDefaultDocumentType() {
        return this.defaultDocumentType;
    }

    public String getDefaultFolderType() {
        return this.defaultFolderType;
    }

    public final Properties getProperties() {
        return this.properties;
    }

    public String getContentType(String fileExtension) {
        return this.properties.getProperty("mapping.contentType.forceContentType." + fileExtension, null);
    }

    String[] getTypeKeys() {
        String s = this.properties.getProperty("mapping.contentTypes");
        if (null == s) {
            return null;
        }
        String[] keys = s.split(",");
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = keys[i].trim();
        }
        return keys;
    }

    void buildMapperMap() {
        String[] typeKeys;
        for (String typeKey : typeKeys = this.getTypeKeys()) {
            PropertyMapper mapper = this.loadMapperClass(typeKey);
            String contentType = this.properties.getProperty("mapping.contentType." + typeKey);
            if (null == contentType) {
                throw new MapperException("Missingt content type in properties: mapping.contentType." + contentType);
            }
            boolean ok = mapper.initialize(PREFIX, typeKey, this.properties);
            if (!ok) continue;
            this.contentTypeMapperMap.put(typeKey, mapper);
        }
    }

    void createParsers() {
        String[] typeKeys;
        for (String typeKey : typeKeys = this.getTypeKeys()) {
            String[] contentTypes;
            MetadataParser parser = this.loadParserClass(typeKey);
            String contentType = this.properties.getProperty("mapping.contentType." + typeKey);
            if (null == contentType) {
                throw new MapperException("Missing content type in properties: mapping.contentType." + contentType);
            }
            PropertyMapper mapper = this.contentTypeMapperMap.get(typeKey);
            parser.initialize(mapper, contentType);
            for (String ct : contentTypes = parser.getContentTypes()) {
                this.parserMap.put(ct, parser);
            }
        }
    }

    MetadataParser loadParserClass(String typeKey) {
        String className = this.properties.getProperty("mapping.contentType." + typeKey + ".parserClass");
        if (null == className) {
            className = MetadataParserTika.class.getName();
        }
        Object obj = null;
        try {
            obj = Class.forName(className).newInstance();
        }
        catch (InstantiationException e) {
            LOG.error((Object)e);
            throw new MapperException("Illegal class to load metadata parser, cannot instantiate " + className, e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)e);
            throw new MapperException("Illegal class to load metadata parser, cannot access " + className, e);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)e);
            throw new MapperException("Illegal class to load metadata parser, class not found: " + className, e);
        }
        if (obj instanceof MetadataParser) {
            return obj;
        }
        throw new MapperException("Illegal class to create metadata parser: " + className + ", must implement MetadataParser interface.");
    }

    PropertyMapper loadMapperClass(String typeKey) {
        String className = this.properties.getProperty("mapping.contentType." + typeKey + ".mapperClass");
        if (null == className) {
            className = PropertyMapperTika.class.getName();
        }
        Object obj = null;
        try {
            obj = Class.forName(className).newInstance();
        }
        catch (InstantiationException e) {
            LOG.error((Object)e);
            throw new MapperException("Illegal class to load mapping configuration, cannot instantiate " + className, e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)e);
            throw new MapperException("Illegal class to load mapping configuration, cannot access " + className, e);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)e);
            throw new MapperException("Illegal class to load mapping configuration, class not found: " + className, e);
        }
        if (obj instanceof PropertyMapper) {
            return obj;
        }
        throw new MapperException("Illegal class to create property mapper: " + className + ", must implement PropertyMapper interface.");
    }
}

