/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.mapper;

import java.util.Properties;
import org.apache.chemistry.opencmis.client.mapper.MapperException;
import org.apache.chemistry.opencmis.client.mapper.PropertyMapper;

public abstract class AbstractPropertyMapper
implements PropertyMapper {
    private static String DEFAULT_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    protected String[] contentTypes;
    protected String cmisTypeId;
    protected String propPrefix;
    protected String dateFormat = DEFAULT_DATE_FORMAT;

    public boolean initialize(String cfgPrefix, String typeKey, Properties properties) {
        this.propPrefix = cfgPrefix + "." + typeKey;
        this.cmisTypeId = properties.getProperty(this.propPrefix + ".typeId");
        String contentTypeEntry = properties.getProperty(this.propPrefix);
        this.contentTypes = contentTypeEntry.split("\\:");
        for (int i = 0; i < this.contentTypes.length; ++i) {
            this.contentTypes[i] = this.contentTypes[i].trim();
        }
        String df = properties.getProperty(this.propPrefix + ".dateFormat");
        if (null != df) {
            this.dateFormat = df;
        }
        if (null == this.cmisTypeId) {
            throw new MapperException("Missingt type id in properties: " + this.propPrefix + ".typeId");
        }
        return true;
    }

    public String getMappedTypeId() {
        return this.cmisTypeId;
    }

    public String[] getContentTypes() {
        return this.contentTypes;
    }
}

