/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.filecopy;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.mapper.Configurator;
import org.apache.chemistry.opencmis.client.mapper.MapperException;
import org.apache.chemistry.opencmis.client.mapper.PropertyMapper;
import org.apache.chemistry.opencmis.client.parser.MetadataParser;
import org.apache.chemistry.opencmis.client.parser.MetadataParserTika;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tika.Tika;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileCopier {
    private static final Log LOG = LogFactory.getLog((String)FileCopier.class.getName());
    private static final Configurator CFG = Configurator.getInstance();
    private Session session;

    public void connect(Map<String, String> parameters) {
        System.out.println("Connecting to a repository ...");
        SessionFactoryImpl sessionFactory = SessionFactoryImpl.newInstance();
        this.session = sessionFactory.createSession(parameters);
        LOG.debug((Object)"Got a connection to repository.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyRecursive(String folderName, String folderId) {
        block6: {
            try {
                File fileOrDir = new File(folderName);
                if (fileOrDir.isDirectory()) {
                    File[] children;
                    String newFolderId = this.createFolderInRepository(fileOrDir.getAbsolutePath(), folderId);
                    for (File file : children = fileOrDir.listFiles()) {
                        if (file.getName().equals(".") || file.getName().equals("..")) continue;
                        this.copyRecursive(file.getAbsolutePath(), newFolderId);
                    }
                    break block6;
                }
                this.copyFileToRepository(fileOrDir.getAbsolutePath(), folderId);
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String copyFileToRepository(String fileName, String folderId) {
        LOG.debug((Object)("uploading file " + fileName));
        FileInputStream is = null;
        Map<Object, Object> properties = new HashMap<String, String>();
        String id = null;
        Folder parentFolder = null == folderId ? this.session.getRootFolder() : (Folder)this.session.getObject(folderId);
        try {
            File f = new File(fileName);
            Tika tika = new Tika();
            String mimeType = tika.detect(f);
            LOG.info((Object)("Detected MIME type: " + mimeType));
            MetadataParser parser = CFG.getParser(mimeType);
            if (null == parser) {
                properties.put("cmis:name", f.getName());
                properties.put("cmis:objectTypeId", CFG.getDefaultDocumentType());
            } else {
                parser.reset();
                PropertyMapper mapper = CFG.getPropertyMapper(mimeType);
                if (null == mapper) {
                    throw new MapperException("Unknown mime type (no configuration): " + mimeType);
                }
                String typeId = mapper.getMappedTypeId();
                if (null == typeId) {
                    throw new MapperException("No CMIS type configured for mime type" + mimeType);
                }
                ObjectType td = this.session.getTypeDefinition(typeId);
                if (null == td) {
                    throw new MapperException("CMIS type " + typeId + " does not exist on server.");
                }
                LOG.info((Object)("Detected MIME type: " + mimeType + " is mapped to CMIS type id: " + td.getId()));
                parser.extractMetadata(f, (TypeDefinition)td);
                properties = parser.getCmisProperties();
            }
            int posLastDot = f.getName().indexOf(46);
            String ext = posLastDot < 0 ? null : f.getName().substring(posLastDot + 1, f.getName().length());
            String overridden = null;
            if (null != ext && (overridden = CFG.getContentType(ext)) != null) {
                mimeType = overridden;
            }
            long length = f.length();
            is = new FileInputStream(fileName);
            ContentStream contentStream = this.session.getObjectFactory().createContentStream(fileName, length, mimeType, (InputStream)is);
            if (!properties.containsKey("cmis:name")) {
                properties.put("cmis:name", f.getName());
            }
            Document doc = parentFolder.createDocument(properties, contentStream, VersioningState.NONE);
            id = doc.getId();
            LOG.info((Object)("New document created with id: " + id + ", name: " + properties.get("cmis:name") + " in folder: " + parentFolder.getId()));
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to create CMIS document.", (Throwable)e);
        }
        finally {
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LOG.error((Object)e);
                }
            }
            LOG.debug((Object)"Conversion and transfer done.");
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createFolderInRepository(String fileName, String parentFolderId) {
        String id = null;
        Folder parentFolder = null == parentFolderId ? this.session.getRootFolder() : (Folder)this.session.getObject(parentFolderId);
        HashMap<String, String> properties = new HashMap<String, String>();
        File f = new File(fileName);
        properties.put("cmis:name", f.getName());
        properties.put("cmis:objectTypeId", CFG.getDefaultFolderType());
        try {
            Folder folder = parentFolder.createFolder(properties);
            id = folder.getId();
            LOG.debug((Object)("New folder created with id: " + folder.getId() + ", path: " + (String)folder.getPaths().get(0)));
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to create CMIS document.", (Throwable)e);
        }
        LOG.info((Object)("New folder created with id: " + id + ", name: " + properties.get("cmis:name") + " in parent folder: " + parentFolder.getId()));
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listMetadata(String fileName) {
        try {
            File f = new File(fileName);
            Tika tika = new Tika();
            String mimeType = tika.detect(f);
            LOG.info((Object)("Detected MIME type: " + mimeType));
            MetadataParser parser = CFG.getParser(mimeType);
            if (null == parser) {
                LOG.warn((Object)("Unknown content type " + mimeType + " no metadata found, listing all tags found in file."));
                MetadataParserTika mpt = new MetadataParserTika();
                mpt.listMetadata(f);
            } else {
                PropertyMapper mapper = CFG.getPropertyMapper(mimeType);
                if (null == mapper) {
                    throw new MapperException("Unknown mime type (no configuration): " + mimeType);
                }
                String typeId = mapper.getMappedTypeId();
                if (null == typeId) {
                    throw new MapperException("No CMIS type configured for mime type" + mimeType);
                }
                TypeDefinition td = null;
                if (null != this.session) {
                    this.session.getTypeDefinition(typeId);
                    if (null == td) {
                        throw new MapperException("CMIS type " + typeId + " does not exist on server.");
                    }
                }
                LOG.info((Object)("Detected MIME type: " + mimeType + " is mapped to CMIS type id: " + td.getId()));
                parser.extractMetadata(f, td);
                Map<String, Object> properties = parser.getCmisProperties();
                for (String key : properties.keySet()) {
                    LOG.info((Object)("Found metadata tag " + key + "mapped to " + properties.get(key)));
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to list metadata", (Throwable)e);
        }
        LOG.debug((Object)"Conversion and transfer done.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String fileName = args[0];
        LOG.debug((Object)("extracting CMIS properties for file " + fileName));
        try {
            new FileCopier().listMetadata(fileName);
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
        LOG.debug((Object)"Extraction done.");
    }
}

