/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools;

import java.io.File;
import java.io.PrintWriter;
import java.sql.Driver;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.access.AbstractDbLoaderDelegate;
import org.apache.cayenne.access.DbLoader;
import org.apache.cayenne.access.DbLoaderDelegate;
import org.apache.cayenne.conn.DriverDataSource;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.MapLoader;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.naming.NamingStrategy;
import org.apache.cayenne.tools.MavenLogger;
import org.apache.cayenne.util.DeleteRuleUpdater;
import org.apache.cayenne.util.Util;
import org.apache.commons.logging.Log;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.xml.sax.InputSource;

public class DbImporterMojo
extends AbstractMojo {
    private String map;
    private boolean overwriteExisting;
    private String schemaName;
    private String tablePattern;
    private boolean importProcedures;
    private String procedurePattern;
    private boolean meaningfulPk;
    private String namingStrategy;
    private String adapter;
    private String driver;
    private String url;
    private String username;
    private String password;
    private Log logger;
    private File mapFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.logger = new MavenLogger(this);
        this.logger.debug((Object)String.format("connection settings - [driver: %s, url: %s, username: %s, password: %s]", this.driver, this.url, this.username, this.password));
        this.logger.info((Object)String.format("importer options - [map: %s, overwriteExisting: %s, schemaName: %s, tablePattern: %s, importProcedures: %s, procedurePattern: %s, meaningfulPk: %s, namingStrategy: %s]", this.map, this.overwriteExisting, this.schemaName, this.tablePattern, this.importProcedures, this.procedurePattern, this.meaningfulPk, this.namingStrategy));
        try {
            JdbcAdapter adapterInst = this.adapter == null ? new JdbcAdapter() : (DbAdapter)Class.forName(this.adapter).newInstance();
            DriverDataSource dataSource = new DriverDataSource((Driver)Class.forName(this.driver).newInstance(), this.url, this.username, this.password);
            LoaderDelegate loaderDelegate = new LoaderDelegate();
            DbLoader loader = new DbLoader(dataSource.getConnection(), (DbAdapter)adapterInst, (DbLoaderDelegate)loaderDelegate);
            loader.setCreatingMeaningfulPK(this.meaningfulPk);
            if (this.namingStrategy != null) {
                NamingStrategy namingStrategyInst = (NamingStrategy)Class.forName(this.namingStrategy).newInstance();
                loader.setNamingStrategy(namingStrategyInst);
            }
            this.mapFile = new File(this.map);
            DataMap dataMap = this.mapFile.exists() ? this.loadDataMap() : new DataMap();
            loader.loadDataMapFromDB(this.schemaName, this.tablePattern, dataMap);
            for (ObjEntity addedObjEntity : loaderDelegate.getAddedObjEntities()) {
                DeleteRuleUpdater.updateObjEntity((ObjEntity)addedObjEntity);
            }
            if (this.importProcedures) {
                loader.loadProceduresFromDB(this.schemaName, this.procedurePattern, dataMap);
            }
            this.mapFile.delete();
            PrintWriter pw = new PrintWriter(this.mapFile);
            dataMap.encodeAsXML(pw);
            pw.close();
        }
        catch (Exception ex) {
            Throwable th = Util.unwindException((Throwable)ex);
            String message = "Error importing database schema";
            if (th.getLocalizedMessage() != null) {
                message = message + ": " + th.getLocalizedMessage();
            }
            this.logger.error((Object)message);
            throw new MojoExecutionException(message, th);
        }
    }

    protected DataMap loadDataMap() throws Exception {
        InputSource in = new InputSource(this.mapFile.getCanonicalPath());
        return new MapLoader().loadDataMap(in);
    }

    final class LoaderDelegate
    extends AbstractDbLoaderDelegate {
        LoaderDelegate() {
        }

        public boolean overwriteDbEntity(DbEntity ent) throws CayenneException {
            return DbImporterMojo.this.overwriteExisting;
        }

        public void dbEntityAdded(DbEntity ent) {
            super.dbEntityAdded(ent);
            DbImporterMojo.this.logger.info((Object)("Added DB entity: " + ent.getName()));
        }

        public void dbEntityRemoved(DbEntity ent) {
            super.dbEntityRemoved(ent);
            DbImporterMojo.this.logger.info((Object)("Removed DB entity: " + ent.getName()));
        }

        public void objEntityAdded(ObjEntity ent) {
            super.objEntityAdded(ent);
            DbImporterMojo.this.logger.info((Object)("Added obj entity: " + ent.getName()));
        }

        public void objEntityRemoved(ObjEntity ent) {
            super.objEntityRemoved(ent);
            DbImporterMojo.this.logger.info((Object)("Removed obj entity: " + ent.getName()));
        }
    }
}

