/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools;

import java.io.File;
import java.sql.Driver;
import javax.sql.DataSource;
import org.apache.cayenne.access.DbGenerator;
import org.apache.cayenne.conn.DriverDataSource;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.MapLoader;
import org.apache.cayenne.tools.MavenLogger;
import org.apache.cayenne.util.Util;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.xml.sax.InputSource;

public class DbGeneratorMojo
extends AbstractMojo {
    private File map;
    private String adapter;
    private String driver;
    private String url;
    private String username;
    private String password;
    private boolean dropTables;
    private boolean dropPK;
    private boolean createTables;
    private boolean createPK;
    private boolean createFK;

    public void execute() throws MojoExecutionException, MojoFailureException {
        MavenLogger logger = new MavenLogger(this);
        logger.info(String.format("connection settings - [driver: %s, url: %s, username: %s]", this.driver, this.url, this.username));
        logger.info(String.format("generator options - [dropTables: %s, dropPK: %s, createTables: %s, createPK: %s, createFK: %s]", this.dropTables, this.dropPK, this.createTables, this.createPK, this.createFK));
        try {
            JdbcAdapter adapterInst = this.adapter == null ? new JdbcAdapter() : (DbAdapter)Class.forName(this.adapter).newInstance();
            DataMap dataMap = this.loadDataMap();
            DbGenerator generator = new DbGenerator((DbAdapter)adapterInst, dataMap);
            generator.setShouldCreateFKConstraints(this.createFK);
            generator.setShouldCreatePKSupport(this.createPK);
            generator.setShouldCreateTables(this.createTables);
            generator.setShouldDropPKSupport(this.dropPK);
            generator.setShouldDropTables(this.dropTables);
            DriverDataSource dataSource = new DriverDataSource((Driver)Class.forName(this.driver).newInstance(), this.url, this.username, this.password);
            generator.runGenerator((DataSource)dataSource);
        }
        catch (Exception ex) {
            Throwable th = Util.unwindException((Throwable)ex);
            String message = "Error generating database";
            if (th.getLocalizedMessage() != null) {
                message = message + ": " + th.getLocalizedMessage();
            }
            logger.error(message);
            throw new MojoExecutionException(message, th);
        }
    }

    protected DataMap loadDataMap() throws Exception {
        InputSource in = new InputSource(this.map.getCanonicalPath());
        return new MapLoader().loadDataMap(in);
    }
}

