/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools;

import java.io.File;
import org.apache.cayenne.gen.ClassGenerationAction;
import org.apache.cayenne.gen.ClientClassGenerationAction;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.tools.CayenneGeneratorEntityFilterAction;
import org.apache.cayenne.tools.CayenneGeneratorMapLoaderAction;
import org.apache.cayenne.tools.MavenLogger;
import org.apache.cayenne.tools.NamePatternMatcher;
import org.apache.commons.logging.Log;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class CayenneGeneratorMojo
extends AbstractMojo {
    private MavenProject project;
    private File additionalMaps;
    private boolean client;
    private File destDir;
    private String encoding;
    private String excludeEntities;
    private String includeEntities;
    private boolean makePairs;
    private File map;
    private String mode;
    private String outputPattern;
    private boolean overwrite;
    private String superPkg;
    private String superTemplate;
    private String template;
    private String embeddableSuperTemplate;
    private String embeddableTemplate;
    private boolean usePkgPath;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.destDir.exists()) {
            this.destDir.mkdirs();
        }
        MavenLogger logger = new MavenLogger(this);
        CayenneGeneratorMapLoaderAction loaderAction = new CayenneGeneratorMapLoaderAction();
        loaderAction.setMainDataMapFile(this.map);
        CayenneGeneratorEntityFilterAction filterAction = new CayenneGeneratorEntityFilterAction();
        filterAction.setClient(this.client);
        filterAction.setNameFilter(new NamePatternMatcher((Log)logger, this.includeEntities, this.excludeEntities));
        try {
            loaderAction.setAdditionalDataMapFiles(this.convertAdditionalDataMaps());
            DataMap dataMap = loaderAction.getMainDataMap();
            ClassGenerationAction generator = this.createGenerator();
            generator.setLogger((Log)logger);
            generator.setTimestamp(this.map.lastModified());
            generator.setDataMap(dataMap);
            generator.addEntities(filterAction.getFilteredEntities(dataMap));
            generator.addEmbeddables(dataMap.getEmbeddables());
            generator.addQueries(dataMap.getQueries());
            generator.execute();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error generating classes: ", e);
        }
    }

    protected File[] convertAdditionalDataMaps() throws Exception {
        if (null == this.additionalMaps) {
            return new File[0];
        }
        if (!this.additionalMaps.isDirectory()) {
            throw new MojoFailureException("'additionalMaps' must be a directory containing only datamap files.");
        }
        String[] maps = this.additionalMaps.list();
        File[] dataMaps = new File[maps.length];
        for (int i = 0; i < maps.length; ++i) {
            dataMaps[i] = new File(maps[i]);
        }
        return dataMaps;
    }

    protected ClassGenerationAction createGenerator() {
        Object action = this.client ? new ClientClassGenerationAction() : new ClassGenerationAction();
        action.setDestDir(this.destDir);
        action.setEncoding(this.encoding);
        action.setMakePairs(this.makePairs);
        action.setArtifactsGenerationMode(this.mode);
        action.setOutputPattern(this.outputPattern);
        action.setOverwrite(this.overwrite);
        action.setSuperPkg(this.superPkg);
        action.setSuperTemplate(this.superTemplate);
        action.setTemplate(this.template);
        action.setEmbeddableSuperTemplate(this.embeddableSuperTemplate);
        action.setEmbeddableTemplate(this.embeddableTemplate);
        action.setUsePkgPath(this.usePkgPath);
        return action;
    }
}

