/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.velocity;

import java.sql.Connection;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.MockOperationObserver;
import org.apache.cayenne.access.jdbc.SQLTemplateAction;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.oracle.OracleAdapter;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.query.CapsStrategy;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.ServerCaseDataSourceFactory;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class BindDirectiveIT
extends ServerCase {
    @Inject
    private ServerCaseDataSourceFactory dataSourceFactory;
    @Inject
    private JdbcAdapter adapter;
    @Inject
    private ObjectContext context;
    @Inject
    private JdbcEventLogger logger;
    @Inject
    private DataNode node;

    @Test
    public void testBindTimestamp() throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("id", new Integer(1));
        parameters.put("name", "ArtistWithDOB");
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2010, 2, 8);
        parameters.put("dob", new Timestamp(cal.getTime().getTime()));
        Map<String, ?> row = this.performInsertForParameters(parameters, false, 1);
        Assert.assertEquals(parameters.get("name"), row.get("ARTIST_NAME"));
        Assert.assertEquals((Object)cal.getTime(), row.get("DATE_OF_BIRTH"));
        Assert.assertNotNull(row.get("DATE_OF_BIRTH"));
        Assert.assertEquals(java.util.Date.class, row.get("DATE_OF_BIRTH").getClass());
    }

    @Test
    public void testBindSQLDate() throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("id", new Integer(1));
        parameters.put("name", "ArtistWithDOB");
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2010, 2, 8);
        parameters.put("dob", new Date(cal.getTime().getTime()));
        Map<String, ?> row = this.performInsertForParameters(parameters, false, 1);
        Assert.assertEquals(parameters.get("name"), row.get("ARTIST_NAME"));
        Assert.assertEquals(parameters.get("dob"), row.get("DATE_OF_BIRTH"));
        Assert.assertNotNull(row.get("DATE_OF_BIRTH"));
        Assert.assertEquals(java.util.Date.class, row.get("DATE_OF_BIRTH").getClass());
    }

    @Test
    public void testBindUtilDate() throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("id", new Integer(1));
        parameters.put("name", "ArtistWithDOB");
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2010, 2, 8);
        parameters.put("dob", cal.getTime());
        Map<String, ?> row = this.performInsertForParameters(parameters, false, 1);
        Assert.assertEquals(parameters.get("name"), row.get("ARTIST_NAME"));
        Assert.assertEquals(parameters.get("dob"), row.get("DATE_OF_BIRTH"));
        Assert.assertNotNull(row.get("DATE_OF_BIRTH"));
        Assert.assertEquals(java.util.Date.class, row.get("DATE_OF_BIRTH").getClass());
    }

    @Test
    public void testBindingForCollection() throws Exception {
        for (int i = 1; i < 4; ++i) {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("id", new Long(i));
            parameters.put("name", "Artist" + i);
            this.performInsertForParameters(parameters, true, i);
        }
        HashSet<String> artistNames = new HashSet<String>();
        artistNames.add("Artist1");
        artistNames.add("Artist3");
        String sql = "SELECT * FROM ARTIST WHERE ARTIST_NAME in (#bind($ARTISTNAMES))";
        SQLTemplate query = new SQLTemplate(Artist.class, sql);
        query.setTemplate(OracleAdapter.class.getName(), "SELECT * FROM ARTIST WHERE RTRIM(ARTIST_NAME) in (#bind($ARTISTNAMES))");
        query.setColumnNamesCapitalization(CapsStrategy.UPPER);
        query.setParams(Collections.singletonMap("ARTISTNAMES", artistNames));
        List result = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)result.size());
    }

    @Test
    public void testBindForPassedNullParam() throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("id", new Long(1L));
        parameters.put("name", "ArtistWithoutDOB");
        parameters.put("dob", null);
        Map<String, ?> row = this.performInsertForParameters(parameters, false, 1);
        Assert.assertEquals(parameters.get("id"), row.get("ARTIST_ID"));
        Assert.assertEquals(parameters.get("name"), row.get("ARTIST_NAME"));
        Assert.assertEquals(parameters.get("dob"), row.get("DATE_OF_BIRTH"));
        Assert.assertNull(row.get("DATE_OF_BIRTH"));
    }

    @Test
    public void testBindWithJDBCForPassedNullParam() throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("id", new Long(1L));
        parameters.put("name", "ArtistWithoutDOB");
        parameters.put("dob", null);
        Map<String, ?> row = this.performInsertForParameters(parameters, true, 1);
        Assert.assertEquals(parameters.get("id"), row.get("ARTIST_ID"));
        Assert.assertEquals(parameters.get("name"), row.get("ARTIST_NAME"));
        Assert.assertEquals(parameters.get("dob"), row.get("DATE_OF_BIRTH"));
        Assert.assertNull(row.get("DATE_OF_BIRTH"));
    }

    @Test
    public void testBindForNotPassedParam() throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("id", new Long(1L));
        parameters.put("name", "ArtistWithoutDOB");
        Map<String, ?> row = this.performInsertForParameters(parameters, false, 1);
        Assert.assertEquals(parameters.get("id"), row.get("ARTIST_ID"));
        Assert.assertEquals(parameters.get("name"), row.get("ARTIST_NAME"));
        Assert.assertNull(row.get("DATE_OF_BIRTH"));
    }

    @Test
    public void testBindWithJDBCForNotPassedParam() throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("id", new Long(1L));
        parameters.put("name", "ArtistWithoutDOB");
        Map<String, ?> row = this.performInsertForParameters(parameters, true, 1);
        Assert.assertEquals(parameters.get("id"), row.get("ARTIST_ID"));
        Assert.assertEquals(parameters.get("name"), row.get("ARTIST_NAME"));
        Assert.assertNull(row.get("DATE_OF_BIRTH"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ?> performInsertForParameters(Map<String, Object> parameters, boolean useJDBCType, int expectedRowCount) throws Exception {
        String templateString = useJDBCType ? "INSERT INTO ARTIST (ARTIST_ID, ARTIST_NAME, DATE_OF_BIRTH) VALUES (#bind($id), #bind($name), #bind($dob 'DATE'))" : "INSERT INTO ARTIST (ARTIST_ID, ARTIST_NAME, DATE_OF_BIRTH) VALUES (#bind($id), #bind($name), #bind($dob))";
        SQLTemplate template = new SQLTemplate(Object.class, templateString);
        template.setParams(parameters);
        SQLTemplateAction action = new SQLTemplateAction(template, this.node);
        Connection c = this.dataSourceFactory.getSharedDataSource().getConnection();
        try {
            MockOperationObserver observer = new MockOperationObserver();
            action.performAction(c, observer);
            int[] batches = observer.countsForQuery(template);
            Assert.assertNotNull((Object)batches);
            Assert.assertEquals((long)1L, (long)batches.length);
            Assert.assertEquals((long)1L, (long)batches[0]);
        }
        finally {
            c.close();
        }
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        query.setFetchingDataRows(true);
        List data = this.context.performQuery(query);
        Assert.assertEquals((long)expectedRowCount, (long)data.size());
        return (Map)data.get(0);
    }
}

