/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.validation;

import org.apache.cayenne.validation.BeanValidationFailure;
import org.apache.cayenne.validation.ValidationResult;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ValidationResultTest {
    private ValidationResult res;
    private Object obj1;
    private Object obj2;

    @Before
    public void setUp() throws Exception {
        this.obj1 = new Object();
        this.obj2 = new Object();
    }

    @Test
    public void testHasFailures() {
        this.res = new ValidationResult();
        this.res.addFailure(new BeanValidationFailure(this.obj1, "obj1 1", "mes obj1 1"));
        Assert.assertTrue((boolean)this.res.hasFailures());
        Assert.assertTrue((boolean)this.res.hasFailures(this.obj1));
        Assert.assertFalse((boolean)this.res.hasFailures(this.obj2));
    }

    @Test
    public void testGetFailures() {
        this.res = new ValidationResult();
        this.res.addFailure(new BeanValidationFailure(this.obj1, "obj1 1", "mes obj1 1"));
        this.res.addFailure(new BeanValidationFailure(this.obj1, "obj1 1", "mes obj1 1"));
        this.res.addFailure(new BeanValidationFailure(this.obj2, "obj1 1", "mes obj1 1"));
        Assert.assertEquals((long)2L, (long)this.res.getFailures(this.obj1).size());
        Assert.assertEquals((long)1L, (long)this.res.getFailures(this.obj2).size());
        Assert.assertEquals((long)3L, (long)this.res.getFailures().size());
    }

    @Test
    public void testEmpty() {
        this.res = new ValidationResult();
        Assert.assertFalse((boolean)this.res.hasFailures());
        Assert.assertFalse((boolean)this.res.hasFailures(this.obj1));
        Assert.assertFalse((boolean)this.res.hasFailures(null));
    }
}

