/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import org.apache.cayenne.map.naming.NameConverter;
import org.junit.Assert;
import org.junit.Test;

public class NameConverterTest {
    @Test
    public void testUnderscoredToJava1() throws Exception {
        String expected = "ClassNameIdentifier";
        Assert.assertEquals((Object)expected, (Object)NameConverter.underscoredToJava("_CLASS_NAME_IDENTIFIER_", true));
    }

    @Test
    public void testUnderscoredToJava2() throws Exception {
        String expected = "propNameIdentifier123";
        Assert.assertEquals((Object)expected, (Object)NameConverter.underscoredToJava("_prop_name_Identifier_123", false));
    }

    @Test
    public void testUnderscoredToJava3() throws Exception {
        String expected = "lastName";
        Assert.assertEquals((Object)expected, (Object)NameConverter.underscoredToJava("lastName", false));
    }

    @Test
    public void testUnderscoredToJava4() throws Exception {
        String expected = "lastName";
        Assert.assertEquals((Object)expected, (Object)NameConverter.underscoredToJava("LastName", false));
    }

    @Test
    public void testUnderscoredToJava5() throws Exception {
        String expected = "LastName";
        Assert.assertEquals((Object)expected, (Object)NameConverter.underscoredToJava("LastName", true));
    }

    @Test
    public void testUnderscoredToJavaSpecialChars() throws Exception {
        Assert.assertEquals((Object)"ABCpoundXyz", (Object)NameConverter.underscoredToJava("ABC#_XYZ", true));
    }

    @Test
    public void testJavaToUnderscored1() throws Exception {
        String expected = "LAST_NAME";
        Assert.assertEquals((Object)expected, (Object)NameConverter.javaToUnderscored("LastName"));
    }

    @Test
    public void testJavaToUnderscored2() throws Exception {
        String expected = "A_CLASS";
        Assert.assertEquals((Object)expected, (Object)NameConverter.javaToUnderscored("aClass"));
    }

    @Test
    public void testJavaToUnderscored3() throws Exception {
        String expected = "VAR_A";
        Assert.assertEquals((Object)expected, (Object)NameConverter.javaToUnderscored("varA"));
    }

    @Test
    public void testJavaToUnderscored4() throws Exception {
        String expected = "LAST_NAME";
        Assert.assertEquals((Object)expected, (Object)NameConverter.javaToUnderscored("LAST_NAME"));
    }

    @Test
    public void testJavaToUnderscored5() throws Exception {
        String expected = "ABC_A";
        Assert.assertEquals((Object)expected, (Object)NameConverter.javaToUnderscored("abc_A"));
    }

    @Test
    public void testJavaToUnderscored6() throws Exception {
        String expected = "A123";
        Assert.assertEquals((Object)expected, (Object)NameConverter.javaToUnderscored("a123"));
    }

    @Test
    public void testJavaToUnderscored7() throws Exception {
        String expected = "AB_CDEF";
        Assert.assertEquals((Object)expected, (Object)NameConverter.javaToUnderscored("abCDEF"));
    }

    @Test
    public void testJavaToUnderscored8() throws Exception {
        String expected = "AB_CE";
        Assert.assertEquals((Object)expected, (Object)NameConverter.javaToUnderscored("abCe"));
    }
}

