/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.cayenne.util.GenericResponse;
import org.apache.cayenne.util.Util;
import org.junit.Assert;
import org.junit.Test;

public class GenericResponseTest {
    @Test
    public void testCreation() throws Exception {
        ArrayList list = new ArrayList();
        list.add(new HashMap());
        GenericResponse r = new GenericResponse();
        r.addBatchUpdateCount(new int[]{1, 2, 3});
        r.addResultList(list);
        Assert.assertEquals((long)2L, (long)r.size());
        Assert.assertTrue((boolean)r.next());
        Assert.assertFalse((boolean)r.isList());
        int[] srInt = r.currentUpdateCount();
        Assert.assertEquals((long)3L, (long)srInt.length);
        Assert.assertEquals((long)2L, (long)srInt[1]);
        Assert.assertTrue((boolean)r.next());
        Assert.assertTrue((boolean)r.isList());
        Assert.assertEquals(list, (Object)r.currentList());
        Assert.assertFalse((boolean)r.next());
    }

    @Test
    public void testSerialization() throws Exception {
        ArrayList list = new ArrayList();
        list.add(new HashMap());
        GenericResponse r = new GenericResponse();
        r.addBatchUpdateCount(new int[]{1, 2, 3});
        r.addResultList(list);
        GenericResponse sr = Util.cloneViaSerialization(r);
        Assert.assertNotNull((Object)sr);
        Assert.assertEquals((long)2L, (long)sr.size());
        Assert.assertTrue((boolean)sr.next());
        Assert.assertFalse((boolean)sr.isList());
        int[] srInt = sr.currentUpdateCount();
        Assert.assertEquals((long)3L, (long)srInt.length);
        Assert.assertEquals((long)2L, (long)srInt[1]);
        Assert.assertTrue((boolean)sr.next());
        Assert.assertTrue((boolean)sr.isList());
        Assert.assertEquals(list, (Object)sr.currentList());
        Assert.assertFalse((boolean)sr.next());
    }
}

