/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.unit.jira;

import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.relationships.FkOfDifferentType;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-relationships.xml")
public class CAY_191IT
extends ServerCase {
    @Inject
    protected DataContext context;
    @Inject
    protected DBHelper dbHelper;
    protected TableHelper tRelationshipHelper;
    protected TableHelper tFkOfDifferentType;

    @Before
    public void setUp() throws Exception {
        this.tRelationshipHelper = new TableHelper(this.dbHelper, "RELATIONSHIP_HELPER");
        this.tRelationshipHelper.setColumns(new String[]{"NAME", "RELATIONSHIP_HELPER_ID"});
        this.tFkOfDifferentType = new TableHelper(this.dbHelper, "FK_OF_DIFFERENT_TYPE");
        this.tFkOfDifferentType.setColumns(new String[]{"ID", "RELATIONSHIP_HELPER_FK"});
    }

    protected void createTestDataSet() throws Exception {
        this.tRelationshipHelper.insert(new Object[]{"RH1", 1});
        this.tFkOfDifferentType.insert(new Object[]{1, 1});
    }

    @Test
    public void testResolveToOneOverFKOfDifferentNumType() throws Exception {
        this.createTestDataSet();
        FkOfDifferentType root = Cayenne.objectForPK((ObjectContext)this.context, FkOfDifferentType.class, 1);
        Assert.assertNotNull((Object)root);
        Assert.assertNotNull((Object)root.getRelationshipHelper());
        Assert.assertEquals((Object)"RH1", (Object)root.getRelationshipHelper().getName());
    }
}

