/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.unit.di.server;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.conn.PoolDataSource;
import org.apache.cayenne.conn.PoolManager;
import org.apache.cayenne.di.Inject;

public class ServerCaseDataSourceFactory {
    private DataSource sharedDataSource;
    private DataSourceInfo dataSourceInfo;
    private Map<String, DataSource> dataSources;
    private Set<String> mapsWithDedicatedDataSource;

    public ServerCaseDataSourceFactory(@Inject DataSourceInfo dataSourceInfo) {
        this.dataSourceInfo = dataSourceInfo;
        this.dataSources = new HashMap<String, DataSource>();
        this.mapsWithDedicatedDataSource = new HashSet<String>(Arrays.asList("map-db1", "map-db2"));
        this.sharedDataSource = this.createDataSource();
    }

    public DataSource getSharedDataSource() {
        return this.sharedDataSource;
    }

    public DataSource getDataSource(String dataMapName) {
        DataSource ds = this.dataSources.get(dataMapName);
        if (ds == null) {
            ds = this.mapsWithDedicatedDataSource.contains(dataMapName) ? this.createDataSource() : this.sharedDataSource;
            this.dataSources.put(dataMapName, ds);
        }
        return ds;
    }

    private DataSource createDataSource() {
        try {
            PoolDataSource poolDS = new PoolDataSource(this.dataSourceInfo.getJdbcDriver(), this.dataSourceInfo.getDataSourceUrl());
            return new PoolManager(poolDS, this.dataSourceInfo.getMinConnections(), this.dataSourceInfo.getMaxConnections(), this.dataSourceInfo.getUserName(), this.dataSourceInfo.getPassword(), 20000L){

                @Override
                public void shutdown() throws SQLException {
                }
            };
        }
        catch (Exception ex) {
            throw new RuntimeException("Can not create shared data source.", ex);
        }
    }
}

