/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.remote.service;

import java.util.HashMap;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.configuration.ObjectContextFactory;
import org.apache.cayenne.event.MockEventBridgeFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.remote.QueryMessage;
import org.apache.cayenne.remote.RemoteSession;
import org.apache.cayenne.remote.service.BaseRemoteService;
import org.apache.cayenne.remote.service.MockUnserializableException;
import org.apache.cayenne.remote.service.ServerSession;
import org.apache.cayenne.util.Util;
import org.junit.Assert;
import org.junit.Test;

public class BaseRemoteServiceTest {
    @Test
    public void testConstructor() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("cayenne.server.rop_event_bridge_factory", MockEventBridgeFactory.class.getName());
        ObjectContextFactory factory = new ObjectContextFactory(){

            @Override
            public ObjectContext createContext(DataChannel parent) {
                return null;
            }

            @Override
            public ObjectContext createContext() {
                return null;
            }
        };
        BaseRemoteService service = new BaseRemoteService(factory, map){

            @Override
            protected ServerSession createServerSession() {
                return null;
            }

            @Override
            protected ServerSession createServerSession(String name) {
                return null;
            }

            @Override
            protected ServerSession getServerSession() {
                return null;
            }
        };
        Assert.assertEquals((Object)MockEventBridgeFactory.class.getName(), (Object)service.getEventBridgeFactoryName());
        Assert.assertSame((Object)factory, (Object)service.contextFactory);
    }

    @Test
    public void testProcessMessageExceptionSerializability() throws Throwable {
        HashMap map = new HashMap();
        ObjectContextFactory factory = new ObjectContextFactory(){

            @Override
            public ObjectContext createContext(DataChannel parent) {
                return null;
            }

            @Override
            public ObjectContext createContext() {
                return null;
            }
        };
        BaseRemoteService service = new BaseRemoteService(factory, map){

            @Override
            protected ServerSession createServerSession() {
                return new ServerSession(new RemoteSession("a"), null);
            }

            @Override
            protected ServerSession createServerSession(String name) {
                return this.createServerSession();
            }

            @Override
            protected ServerSession getServerSession() {
                return this.createServerSession();
            }
        };
        try {
            service.processMessage(new QueryMessage(null){

                @Override
                public Query getQuery() {
                    throw new CayenneRuntimeException();
                }
            });
            Assert.fail((String)"Expected to throw");
        }
        catch (Exception ex) {
            Util.cloneViaSerialization(ex);
        }
        try {
            service.processMessage(new QueryMessage(null){

                @Override
                public Query getQuery() {
                    throw new MockUnserializableException();
                }
            });
            Assert.fail((String)"Expected to throw");
        }
        catch (Exception ex) {
            Util.cloneViaSerialization(ex);
        }
    }
}

