/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ValueHolder;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.mixed_persistence_strategy.MixedPersistenceStrategy;
import org.apache.cayenne.testdo.mixed_persistence_strategy.MixedPersistenceStrategy2;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-mixed-persistence-strategy.xml")
public class MixedPersistenceStrategyIT
extends ServerCase {
    @Inject
    protected ObjectContext context;
    @Inject
    protected DBHelper dbHelper;
    protected TableHelper tMixedPersistenceStrategy;
    protected TableHelper tMixedPersistenceStrategy2;

    @Before
    public void setUp() throws Exception {
        this.tMixedPersistenceStrategy = new TableHelper(this.dbHelper, "MIXED_PERSISTENCE_STRATEGY");
        this.tMixedPersistenceStrategy.setColumns(new String[]{"ID", "DESCRIPTION", "NAME"});
        this.tMixedPersistenceStrategy2 = new TableHelper(this.dbHelper, "MIXED_PERSISTENCE_STRATEGY2");
        this.tMixedPersistenceStrategy2.setColumns(new String[]{"ID", "MASTER_ID", "NAME"});
    }

    protected void createConflictingFieldDataSet() throws Exception {
        this.tMixedPersistenceStrategy.insert(new Object[]{1, "d1", "n1"});
        this.tMixedPersistenceStrategy2.insert(new Object[]{1, 1, "dn1"});
        this.tMixedPersistenceStrategy2.insert(new Object[]{2, 1, "dn2"});
    }

    @Test
    public void testConflictingField1() throws Exception {
        this.createConflictingFieldDataSet();
        MixedPersistenceStrategy object = Cayenne.objectForPK(this.context, MixedPersistenceStrategy.class, 1);
        Assert.assertEquals((long)2L, (long)object.getDetails().size());
        Assert.assertTrue((boolean)(object.getDetails() instanceof ValueHolder));
    }

    @Test
    public void testConflictingField2() throws Exception {
        this.createConflictingFieldDataSet();
        MixedPersistenceStrategy2 detail1 = Cayenne.objectForPK(this.context, MixedPersistenceStrategy2.class, 1);
        MixedPersistenceStrategy2 detail2 = Cayenne.objectForPK(this.context, MixedPersistenceStrategy2.class, 2);
        Assert.assertEquals((Object)"n1", (Object)detail1.getMaster().getName());
        Assert.assertEquals((long)2L, (long)detail2.getMaster().getDetails().size());
        Assert.assertTrue((boolean)(detail2.getMaster().getDetails() instanceof ValueHolder));
    }
}

