/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.apache.cayenne.reflect.Accessor;
import org.apache.cayenne.reflect.PropertyException;
import org.apache.cayenne.reflect.PropertyUtils;

public class BeanAccessor
implements Accessor {
    protected String propertyName;
    protected Method readMethod;
    protected Method writeMethod;
    protected Object nullValue;

    public BeanAccessor(Class<?> objectClass, String propertyName, Class<?> propertyType) {
        if (objectClass == null) {
            throw new IllegalArgumentException("Null objectClass");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("Null propertyName");
        }
        this.propertyName = propertyName;
        this.nullValue = PropertyUtils.defaultNullValueForType(propertyType);
        try {
            PropertyDescriptor descriptor = new PropertyDescriptor(propertyName, objectClass);
            this.readMethod = descriptor.getReadMethod();
            this.writeMethod = descriptor.getWriteMethod();
        }
        catch (IntrospectionException e) {
            throw new PropertyException("Invalid bean property: " + propertyName, (Accessor)this, (Object)e, new Object[0]);
        }
    }

    @Override
    public String getName() {
        return this.propertyName;
    }

    @Override
    public Object getValue(Object object) throws PropertyException {
        if (this.readMethod == null) {
            throw new PropertyException("Property '" + this.propertyName + "' is not readable", (Accessor)this, object, new Object[0]);
        }
        try {
            return this.readMethod.invoke(object, (Object[])null);
        }
        catch (Throwable th) {
            throw new PropertyException("Error reading property: " + this.propertyName, (Accessor)this, object, th, new Object[0]);
        }
    }

    @Override
    public void setValue(Object object, Object newValue) throws PropertyException {
        if (this.writeMethod == null) {
            throw new PropertyException("Property '" + this.propertyName + "' is not writable", (Accessor)this, object, new Object[0]);
        }
        if (newValue == null) {
            newValue = this.nullValue;
        }
        try {
            this.writeMethod.invoke(object, newValue);
        }
        catch (Throwable th) {
            throw new PropertyException("Error reading property: " + this.propertyName, (Accessor)this, object, th, new Object[0]);
        }
    }
}

