/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.ASTBitwiseAnd;
import org.apache.cayenne.exp.parser.ASTBitwiseNot;
import org.apache.cayenne.exp.parser.ASTBitwiseOr;
import org.apache.cayenne.exp.parser.ASTBitwiseXor;
import org.apache.cayenne.exp.parser.ASTEqual;
import org.apache.cayenne.exp.parser.ASTGreater;
import org.apache.cayenne.exp.parser.ASTObjPath;
import org.apache.cayenne.exp.parser.ASTScalar;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.return_types.ReturnTypesMap1;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-return-types.xml")
public class SelectQueryReturnTypesIT
extends ServerCase {
    @Inject
    private ObjectContext context;
    @Inject
    private DBHelper dbHelper;
    @Inject
    private UnitDbAdapter accessStackAdapter;

    protected void createNumericsDataSet() throws Exception {
        TableHelper tNumerics = new TableHelper(this.dbHelper, "TYPES_MAPPING_TEST1");
        tNumerics.setColumns(new String[]{"AAAID", "INTEGER_COLUMN"});
        tNumerics.insert(new Object[]{1, 0});
        tNumerics.insert(new Object[]{2, 1});
        tNumerics.insert(new Object[]{3, 2});
        tNumerics.insert(new Object[]{4, 3});
        tNumerics.insert(new Object[]{5, 4});
    }

    @Test
    public void testSelectBitwiseNot() throws Exception {
        if (!this.accessStackAdapter.supportsBitwiseOps()) {
            return;
        }
        this.createNumericsDataSet();
        ASTBitwiseNot left = new ASTBitwiseNot(new ASTBitwiseNot(new ASTObjPath("integerColumn")));
        ASTScalar right = new ASTScalar((Object)2);
        ASTGreater greater = new ASTGreater();
        ((Expression)greater).setOperand(0, left);
        ((Expression)greater).setOperand(1, right);
        SelectQuery<ReturnTypesMap1> query = new SelectQuery<ReturnTypesMap1>(ReturnTypesMap1.class);
        query.setQualifier(greater);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)objects.size());
    }

    @Test
    public void testSelectBitwiseOr() throws Exception {
        if (!this.accessStackAdapter.supportsBitwiseOps()) {
            return;
        }
        this.createNumericsDataSet();
        ASTBitwiseOr left = new ASTBitwiseOr(new Object[]{new ASTObjPath("integerColumn"), new ASTScalar((Object)1)});
        ASTScalar right = new ASTScalar((Object)1);
        ASTEqual equal = new ASTEqual();
        ((Expression)equal).setOperand(0, left);
        ((Expression)equal).setOperand(1, right);
        SelectQuery<ReturnTypesMap1> query = new SelectQuery<ReturnTypesMap1>(ReturnTypesMap1.class);
        query.setQualifier(equal);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)objects.size());
    }

    @Test
    public void testSelectBitwiseAnd() throws Exception {
        if (!this.accessStackAdapter.supportsBitwiseOps()) {
            return;
        }
        this.createNumericsDataSet();
        ASTBitwiseAnd left = new ASTBitwiseAnd(new Object[]{new ASTObjPath("integerColumn"), new ASTScalar((Object)1)});
        ASTScalar right = new ASTScalar((Object)0);
        ASTEqual equal = new ASTEqual();
        ((Expression)equal).setOperand(0, left);
        ((Expression)equal).setOperand(1, right);
        SelectQuery<ReturnTypesMap1> query = new SelectQuery<ReturnTypesMap1>(ReturnTypesMap1.class);
        query.setQualifier(equal);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)3L, (long)objects.size());
    }

    @Test
    public void testSelectBitwiseXor() throws Exception {
        if (!this.accessStackAdapter.supportsBitwiseOps()) {
            return;
        }
        this.createNumericsDataSet();
        ASTBitwiseXor left = new ASTBitwiseXor(new Object[]{new ASTObjPath("integerColumn"), new ASTScalar((Object)1)});
        ASTScalar right = new ASTScalar((Object)5);
        ASTEqual equal = new ASTEqual();
        ((Expression)equal).setOperand(0, left);
        ((Expression)equal).setOperand(1, right);
        SelectQuery<ReturnTypesMap1> query = new SelectQuery<ReturnTypesMap1>(ReturnTypesMap1.class);
        query.setQualifier(equal);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
        Assert.assertEquals((long)4L, (long)((ReturnTypesMap1)objects.get(0)).getIntegerColumn().intValue());
    }
}

