/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.ExpressionParameter;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.query.SortOrder;
import org.apache.cayenne.testdo.testmap.Artist;
import org.junit.Assert;
import org.junit.Test;

public class SelectQueryBasicsTest {
    @Test
    public void testAddPrefetch() {
        SelectQuery q = new SelectQuery();
        Assert.assertNull((Object)q.getPrefetchTree());
        q.addPrefetch("a.b.c");
        Assert.assertNotNull((Object)q.getPrefetchTree());
        Assert.assertEquals((long)1L, (long)q.getPrefetchTree().nonPhantomNodes().size());
        Assert.assertNotNull((Object)q.getPrefetchTree().getNode("a.b.c"));
    }

    @Test
    public void testAddPrefetchDuplicates() {
        SelectQuery q = new SelectQuery();
        q.addPrefetch("a.b.c");
        q.addPrefetch("a.b.c");
        Assert.assertEquals((long)1L, (long)q.getPrefetchTree().nonPhantomNodes().size());
    }

    @Test
    public void testClearPrefetches() {
        SelectQuery q = new SelectQuery();
        q.addPrefetch("abc");
        q.addPrefetch("xyz");
        Assert.assertNotNull((Object)q.getPrefetchTree());
        q.clearPrefetches();
        Assert.assertNull((Object)q.getPrefetchTree());
    }

    @Test
    public void testPageSize() throws Exception {
        SelectQuery q = new SelectQuery();
        q.setPageSize(10);
        Assert.assertEquals((long)10L, (long)q.getPageSize());
    }

    @Test
    public void testAddOrdering1() throws Exception {
        SelectQuery q = new SelectQuery();
        Ordering ord = new Ordering();
        q.addOrdering(ord);
        Assert.assertEquals((long)1L, (long)q.getOrderings().size());
        Assert.assertSame((Object)ord, (Object)q.getOrderings().get(0));
    }

    @Test
    public void testAddOrdering2() throws Exception {
        SelectQuery q = new SelectQuery();
        String path = "a.b.c";
        q.addOrdering(path, SortOrder.DESCENDING);
        Assert.assertEquals((long)1L, (long)q.getOrderings().size());
        Ordering ord = q.getOrderings().get(0);
        Assert.assertEquals((Object)path, (Object)ord.getSortSpec().getOperand(0));
        Assert.assertEquals((Object)false, (Object)ord.isAscending());
    }

    @Test
    public void testDistinct() throws Exception {
        SelectQuery q = new SelectQuery();
        Assert.assertFalse((boolean)q.isDistinct());
        q.setDistinct(true);
        Assert.assertTrue((boolean)q.isDistinct());
    }

    @Test
    public void testQueryWithParams1() {
        SelectQuery q = new SelectQuery();
        q.setRoot(Artist.class);
        q.setDistinct(true);
        SelectQuery q1 = q.queryWithParameters(new HashMap(), true);
        Assert.assertSame((Object)q.getRoot(), (Object)q1.getRoot());
        Assert.assertEquals((Object)q.isDistinct(), (Object)q1.isDistinct());
        Assert.assertNull((Object)q1.getQualifier());
    }

    @Test
    public void testQueryWithParams2() throws Exception {
        SelectQuery q = new SelectQuery();
        q.setRoot(Artist.class);
        ArrayList<Expression> list = new ArrayList<Expression>();
        list.add(ExpressionFactory.matchExp("k1", new ExpressionParameter("test1")));
        list.add(ExpressionFactory.matchExp("k2", new ExpressionParameter("test2")));
        list.add(ExpressionFactory.matchExp("k3", new ExpressionParameter("test3")));
        list.add(ExpressionFactory.matchExp("k4", new ExpressionParameter("test4")));
        q.setQualifier(ExpressionFactory.joinExp(1, list));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("test2", "abc");
        params.put("test3", "xyz");
        SelectQuery q1 = q.queryWithParameters(params, true);
        Assert.assertSame((Object)q.getRoot(), (Object)q1.getRoot());
        Assert.assertNotNull((Object)q1.getQualifier());
        Assert.assertTrue((q1.getQualifier() != q.getQualifier() ? 1 : 0) != 0);
    }

    @Test
    public void testQueryWithParamsSkipName() {
        SelectQuery q = new SelectQuery();
        q.setRoot(Artist.class);
        q.setDistinct(true);
        q.setName("name");
        SelectQuery q1 = q.queryWithParameters(Collections.EMPTY_MAP);
        Assert.assertEquals((Object)"name", (Object)q.getName());
        Assert.assertNull((Object)q1.getName());
    }
}

