/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.Arrays;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.SQLSelect;
import org.apache.cayenne.query.SQLTemplate;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class SQLSelectTest {
    @Test
    public void testCacheGroups_Collection() {
        SQLSelect<DataRow> q = SQLSelect.dataRowQuery("bla");
        Assert.assertNull((Object)((Object)q.getCacheStrategy()));
        Assert.assertNull((Object)q.getCacheGroups());
        q.cacheGroups(Arrays.asList("a", "b"));
        Assert.assertNull((Object)((Object)q.getCacheStrategy()));
        Assert.assertArrayEquals((Object[])new String[]{"a", "b"}, (Object[])q.getCacheGroups());
    }

    @Test
    public void testCacheStrategy() {
        SQLSelect<DataRow> q = SQLSelect.dataRowQuery("bla");
        Assert.assertNull((Object)((Object)q.getCacheStrategy()));
        Assert.assertNull((Object)q.getCacheGroups());
        q.cacheStrategy(QueryCacheStrategy.LOCAL_CACHE, "a", "b");
        Assert.assertSame((Object)((Object)QueryCacheStrategy.LOCAL_CACHE), (Object)((Object)q.getCacheStrategy()));
        Assert.assertArrayEquals((Object[])new String[]{"a", "b"}, (Object[])q.getCacheGroups());
        q.cacheStrategy(QueryCacheStrategy.SHARED_CACHE, new String[0]);
        Assert.assertSame((Object)((Object)QueryCacheStrategy.SHARED_CACHE), (Object)((Object)q.getCacheStrategy()));
        Assert.assertNull((Object)q.getCacheGroups());
    }

    @Test
    public void testLocalCache() {
        SQLSelect<DataRow> q = SQLSelect.dataRowQuery("bla");
        Assert.assertNull((Object)((Object)q.getCacheStrategy()));
        Assert.assertNull((Object)q.getCacheGroups());
        q.localCache("a", "b");
        Assert.assertSame((Object)((Object)QueryCacheStrategy.LOCAL_CACHE), (Object)((Object)q.getCacheStrategy()));
        Assert.assertArrayEquals((Object[])new String[]{"a", "b"}, (Object[])q.getCacheGroups());
        q.localCache(new String[0]);
        Assert.assertSame((Object)((Object)QueryCacheStrategy.LOCAL_CACHE), (Object)((Object)q.getCacheStrategy()));
        Assert.assertNull((Object)q.getCacheGroups());
    }

    @Test
    public void testSharedCache() {
        SQLSelect<DataRow> q = SQLSelect.dataRowQuery("bla");
        Assert.assertNull((Object)((Object)q.getCacheStrategy()));
        Assert.assertNull((Object)q.getCacheGroups());
        q.sharedCache("a", "b");
        Assert.assertSame((Object)((Object)QueryCacheStrategy.SHARED_CACHE), (Object)((Object)q.getCacheStrategy()));
        Assert.assertArrayEquals((Object[])new String[]{"a", "b"}, (Object[])q.getCacheGroups());
        q.sharedCache(new String[0]);
        Assert.assertSame((Object)((Object)QueryCacheStrategy.SHARED_CACHE), (Object)((Object)q.getCacheStrategy()));
        Assert.assertNull((Object)q.getCacheGroups());
    }

    @Test
    public void testCreateReplacementQuery() {
        SQLSelect<DataRow> q = SQLSelect.dataRowQuery("bla");
        Query replacement = q.createReplacementQuery((EntityResolver)Mockito.mock(EntityResolver.class));
        Assert.assertThat((Object)replacement, (Matcher)CoreMatchers.instanceOf(SQLTemplate.class));
    }

    @Test
    public void testCreateReplacementQuery_ParamsArray_Single() {
        SQLSelect<DataRow> q = SQLSelect.dataRowQuery("bla").paramsArray("a");
        SQLTemplate replacement = (SQLTemplate)q.createReplacementQuery((EntityResolver)Mockito.mock(EntityResolver.class));
        Assert.assertArrayEquals((Object[])new Object[]{"a"}, (Object[])replacement.getPositionalParams().toArray());
    }

    @Test
    public void testCreateReplacementQuery_ParamsArray_Multiple() {
        SQLSelect<DataRow> q = SQLSelect.dataRowQuery("bla").paramsArray("a", "b");
        SQLTemplate replacement = (SQLTemplate)q.createReplacementQuery((EntityResolver)Mockito.mock(EntityResolver.class));
        Assert.assertArrayEquals((Object[])new Object[]{"a", "b"}, (Object[])replacement.getPositionalParams().toArray());
    }

    @Test
    public void testGetMetadata_ParamsArray_Multiple_Cache() {
        EntityResolver resolver = (EntityResolver)Mockito.mock(EntityResolver.class);
        QueryMetadata md0 = SQLSelect.dataRowQuery("bla").localCache(new String[0]).getMetaData(resolver);
        QueryMetadata md1 = SQLSelect.dataRowQuery("bla").localCache(new String[0]).paramsArray("a").getMetaData(resolver);
        QueryMetadata md2 = SQLSelect.dataRowQuery("bla").localCache(new String[0]).paramsArray("a", "b").getMetaData(resolver);
        QueryMetadata md3 = SQLSelect.dataRowQuery("bla").localCache(new String[0]).paramsArray(null, "b").getMetaData(resolver);
        Assert.assertNotNull((Object)md0.getCacheKey());
        Assert.assertNotNull((Object)md1.getCacheKey());
        Assert.assertNotNull((Object)md2.getCacheKey());
        Assert.assertNotNull((Object)md3.getCacheKey());
        Assert.assertNotEquals((Object)md0.getCacheKey(), (Object)md1.getCacheKey());
        Assert.assertNotEquals((Object)md0.getCacheKey(), (Object)md2.getCacheKey());
        Assert.assertNotEquals((Object)md1.getCacheKey(), (Object)md2.getCacheKey());
        Assert.assertNotEquals((Object)md3.getCacheKey(), (Object)md2.getCacheKey());
    }
}

