/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.Collections;
import java.util.HashMap;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.query.CapsStrategy;
import org.apache.cayenne.query.ProcedureQuery;
import org.apache.cayenne.query.Query;
import org.junit.Assert;
import org.junit.Test;

public class ProcedureQueryTest {
    @Test
    public void testCreateQuery() {
        ProcedureQuery template = new ProcedureQuery();
        Query clone = template.createQuery(Collections.EMPTY_MAP);
        Assert.assertTrue((boolean)(clone instanceof ProcedureQuery));
        Assert.assertNotSame((Object)template, (Object)clone);
    }

    @Test
    public void testColumnNameCapitalization() {
        ProcedureQuery q1 = new ProcedureQuery();
        Assert.assertSame((Object)((Object)CapsStrategy.DEFAULT), (Object)((Object)q1.getColumnNamesCapitalization()));
        q1.setColumnNamesCapitalization(CapsStrategy.UPPER);
        Assert.assertEquals((Object)((Object)CapsStrategy.UPPER), (Object)((Object)q1.getColumnNamesCapitalization()));
    }

    @Test
    public void testCreateQueryWithParameters() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("a", "1");
        params.put("b", "2");
        ProcedureQuery template = new ProcedureQuery();
        ProcedureQuery clone = (ProcedureQuery)template.createQuery(params);
        Assert.assertEquals(params, clone.getParameters());
    }

    @Test
    public void testResultEntityName() {
        ProcedureQuery query = new ProcedureQuery();
        Assert.assertNull((Object)query.getResultEntityName());
        query.setResultEntityName("abc.AAAA");
        Assert.assertSame((Object)"abc.AAAA", (Object)query.getResultEntityName());
    }

    @Test
    public void testResultDescriptors() {
        ProcedureQuery query = new ProcedureQuery();
        Assert.assertNotNull(query.getResultDescriptors());
        Assert.assertTrue((boolean)query.getResultDescriptors().isEmpty());
        ColumnDescriptor[] descriptor = new ColumnDescriptor[5];
        query.addResultDescriptor(descriptor);
        Assert.assertEquals((long)1L, (long)query.getResultDescriptors().size());
        Assert.assertTrue((boolean)query.getResultDescriptors().contains(descriptor));
        query.removeResultDescriptor(descriptor);
        Assert.assertNotNull(query.getResultDescriptors());
        Assert.assertTrue((boolean)query.getResultDescriptors().isEmpty());
    }
}

