/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge.builders;

import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.merge.builders.DefaultBuilder;

public class DbRelationshipBuilder
extends DefaultBuilder<DbRelationship> {
    private String[] from;
    private String[] to;

    public DbRelationshipBuilder() {
        super(new DbRelationship());
    }

    public DbRelationshipBuilder(String name) {
        super(new DbRelationship(name));
    }

    public DbRelationshipBuilder(DbRelationship obj) {
        super(obj);
    }

    public DbRelationshipBuilder name() {
        return this.name(this.getRandomJavaName());
    }

    public DbRelationshipBuilder name(String name) {
        ((DbRelationship)this.obj).setName(name);
        return this;
    }

    public DbRelationshipBuilder from(DbEntity entity, String ... columns) {
        ((DbRelationship)this.obj).setSourceEntity(entity);
        this.from = columns;
        return this;
    }

    public DbRelationshipBuilder to(String entityName, String ... columns) {
        ((DbRelationship)this.obj).setTargetEntityName(entityName);
        this.to = columns;
        return this;
    }

    @Override
    public DbRelationship build() {
        if (((DbRelationship)this.obj).getName() == null) {
            this.name();
        }
        if (this.from.length != this.to.length) {
            throw new IllegalStateException("from and to columns name size mismatch");
        }
        for (int i = 0; i < this.from.length; ++i) {
            ((DbRelationship)this.obj).addJoin(new DbJoin((DbRelationship)this.obj, this.from[i], this.to[i]));
        }
        return (DbRelationship)this.obj;
    }
}

