/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import java.util.Collections;
import org.apache.cayenne.dba.hsqldb.HSQLMergerFactory;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.merge.DefaultValueForNullProvider;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;
import org.apache.cayenne.merge.builders.ObjectMother;
import org.junit.Assert;
import org.junit.Test;

public class TokensReversTest {
    @Test
    public void testReverses() {
        DbAttribute attr = ObjectMother.dbAttr().build();
        DbEntity entity = ObjectMother.dbEntity().attributes(attr).build();
        DbRelationship rel = new DbRelationship("rel");
        rel.setSourceEntity(entity);
        rel.addJoin(new DbJoin(rel, attr.getName(), "dontKnow"));
        this.test(this.factory().createAddColumnToDb(entity, attr));
        this.test(this.factory().createAddColumnToModel(entity, attr));
        this.test(this.factory().createDropColumnToDb(entity, attr));
        this.test(this.factory().createDropColumnToModel(entity, attr));
        this.test(this.factory().createAddRelationshipToDb(entity, rel));
        this.test(this.factory().createAddRelationshipToModel(entity, rel));
        this.test(this.factory().createDropRelationshipToDb(entity, rel));
        this.test(this.factory().createDropRelationshipToModel(entity, rel));
        this.test(this.factory().createCreateTableToDb(entity));
        this.test(this.factory().createCreateTableToModel(entity));
        this.test(this.factory().createDropTableToDb(entity));
        this.test(this.factory().createDropTableToModel(entity));
        this.test(this.factory().createSetAllowNullToDb(entity, attr));
        this.test(this.factory().createSetAllowNullToModel(entity, attr));
        this.test(this.factory().createSetNotNullToDb(entity, attr));
        this.test(this.factory().createSetNotNullToModel(entity, attr));
        DbAttribute attr2 = ObjectMother.dbAttr().build();
        this.test(this.factory().createSetColumnTypeToDb(entity, attr, attr2));
        this.test(this.factory().createSetColumnTypeToModel(entity, attr, attr2));
        this.test(this.factory().createSetPrimaryKeyToDb(entity, Collections.singleton(attr), Collections.singleton(attr2), "PK"));
        this.test(this.factory().createSetPrimaryKeyToModel(entity, Collections.singleton(attr), Collections.singleton(attr2), "PK"));
        this.test(this.factory().createSetValueForNullToDb(entity, attr, new DefaultValueForNullProvider()));
    }

    private void test(MergerToken token1) {
        MergerToken token2 = token1.createReverse(this.factory()).createReverse(this.factory());
        Assert.assertEquals((Object)token1.getTokenName(), (Object)token2.getTokenName());
        Assert.assertEquals((Object)token1.getTokenValue(), (Object)token2.getTokenValue());
        Assert.assertEquals((Object)((Object)token1.getDirection()), (Object)((Object)token2.getDirection()));
    }

    private MergerFactory factory() {
        return new HSQLMergerFactory();
    }
}

