/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.merge.AbstractToModelToken;
import org.apache.cayenne.merge.MergerContext;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;

public class DropTableToModel
extends AbstractToModelToken.Entity {
    public DropTableToModel(DbEntity entity) {
        super("Drop Table", entity);
    }

    @Override
    public MergerToken createReverse(MergerFactory factory) {
        return factory.createCreateTableToDb(this.getEntity());
    }

    @Override
    public void execute(MergerContext mergerContext) {
        for (ObjEntity objEntity : this.getEntity().mappedObjEntities()) {
            objEntity.getDataMap().removeObjEntity(objEntity.getName(), true);
            mergerContext.getModelMergeDelegate().objEntityRemoved(objEntity);
        }
        this.getEntity().getDataMap().removeDbEntity(this.getEntity().getName(), true);
        mergerContext.getModelMergeDelegate().dbEntityRemoved(this.getEntity());
    }
}

