/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.access.loader.DbLoaderConfiguration;
import org.apache.cayenne.dba.hsqldb.HSQLMergerFactory;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.merge.DbMerger;
import org.apache.cayenne.merge.MergerToken;
import org.apache.cayenne.merge.builders.DbEntityBuilder;
import org.apache.cayenne.merge.builders.ObjectMother;
import org.junit.Assert;
import org.junit.Test;

public class DbMergerTest {
    @Test
    public void testEmptyDataMap() throws Exception {
        Assert.assertEquals((long)0L, (long)this.dbMerger().createMergeTokens(new ArrayList<DbEntity>(0), new ArrayList<DbEntity>(0), new DbLoaderConfiguration()).size());
    }

    @Test
    public void testAddTable() throws Exception {
        DbEntityBuilder dbEntity = ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeInt());
        DataMap existing = ObjectMother.dataMap().with(dbEntity).build();
        List<MergerToken> tokens = this.dbMerger().createMergeTokens(existing.getDbEntities(), new ArrayList<DbEntity>(0), new DbLoaderConfiguration());
        Assert.assertEquals((long)1L, (long)tokens.size());
        Assert.assertEquals((Object)this.factory().createCreateTableToDb(dbEntity.build()).getTokenValue(), (Object)tokens.get(0).getTokenValue());
    }

    @Test
    public void testRemoveTable() throws Exception {
        DataMap db = ObjectMother.dataMap().with(ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeInt())).build();
        List<MergerToken> tokens = this.dbMerger().createMergeTokens(new ArrayList<DbEntity>(0), db.getDbEntities(), new DbLoaderConfiguration());
        Assert.assertEquals((long)1L, (long)tokens.size());
        Assert.assertEquals((Object)this.factory().createDropTableToDb(db.getDbEntity("table1")).getTokenValue(), (Object)tokens.get(0).getTokenValue());
    }

    @Test
    public void testAddColumn() throws Exception {
        DataMap existing = ObjectMother.dataMap().with(ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeInt(), ObjectMother.dbAttr("attr02").typeInt())).build();
        DataMap db = ObjectMother.dataMap().with(ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeInt())).build();
        List<MergerToken> tokens = this.dbMerger().createMergeTokens(existing.getDbEntities(), db.getDbEntities(), new DbLoaderConfiguration());
        Assert.assertEquals((long)1L, (long)tokens.size());
        DbEntity entity = existing.getDbEntity("table1");
        Assert.assertEquals((Object)this.factory().createAddColumnToDb(entity, entity.getAttribute("attr02")).getTokenValue(), (Object)tokens.get(0).getTokenValue());
    }

    @Test
    public void testAddRelationship() throws Exception {
        DataMap existing = ObjectMother.dataMap().with(ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeInt(), ObjectMother.dbAttr("attr02").typeInt()), ObjectMother.dbEntity("table2").attributes(ObjectMother.dbAttr("attr01").typeInt().primaryKey(), ObjectMother.dbAttr("attr02").typeInt())).join("rel", "table1.attr01", "table2.attr01").build();
        DataMap db = ObjectMother.dataMap().with(ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeInt(), ObjectMother.dbAttr("attr02").typeInt()), ObjectMother.dbEntity("table2").attributes(ObjectMother.dbAttr("attr01").typeInt().primaryKey(), ObjectMother.dbAttr("attr02").typeInt())).build();
        List<MergerToken> tokens = this.dbMerger().createMergeTokens(existing.getDbEntities(), db.getDbEntities(), new DbLoaderConfiguration());
        Assert.assertEquals((long)1L, (long)tokens.size());
        DbEntity entity = existing.getDbEntity("table1");
        Assert.assertEquals((Object)this.factory().createAddRelationshipToDb(entity, entity.getRelationship("rel")).getTokenValue(), (Object)tokens.get(0).getTokenValue());
    }

    @Test
    public void testAddRelationship1() throws Exception {
        DataMap existing = ObjectMother.dataMap().with(ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeInt(), ObjectMother.dbAttr("attr02").typeInt()), ObjectMother.dbEntity("table2").attributes(ObjectMother.dbAttr("attr01").typeInt().primaryKey(), ObjectMother.dbAttr("attr02").typeInt().primaryKey(), ObjectMother.dbAttr("attr03").typeInt().primaryKey())).join("rel", "table1.attr01", "table2.attr01").join("rel1", "table1.attr01", "table2.attr03").build();
        DataMap db = ObjectMother.dataMap().with(ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeInt(), ObjectMother.dbAttr("attr02").typeInt()), ObjectMother.dbEntity("table2").attributes(ObjectMother.dbAttr("attr01").typeInt().primaryKey(), ObjectMother.dbAttr("attr02").typeInt().primaryKey(), ObjectMother.dbAttr("attr03").typeInt().primaryKey())).join("rel", "table1.attr01", "table2.attr02").join("rel1", "table1.attr01", "table2.attr03").build();
        List<MergerToken> tokens = this.dbMerger().createMergeTokens(existing.getDbEntities(), db.getDbEntities(), new DbLoaderConfiguration());
        Assert.assertEquals((long)2L, (long)tokens.size());
        DbEntity entity = existing.getDbEntity("table1");
        Assert.assertEquals((Object)this.factory().createDropRelationshipToDb(entity, entity.getRelationship("rel")).getTokenValue(), (Object)tokens.get(0).getTokenValue());
        entity = db.getDbEntity("table1");
        Assert.assertEquals((Object)this.factory().createAddRelationshipToDb(entity, entity.getRelationship("rel")).getTokenValue(), (Object)tokens.get(0).getTokenValue());
    }

    @Test
    public void testRemoveRelationship() throws Exception {
        DataMap existing = ObjectMother.dataMap().with(ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeInt(), ObjectMother.dbAttr("attr02").typeInt()), ObjectMother.dbEntity("table2").attributes(ObjectMother.dbAttr("attr01").typeInt().primaryKey(), ObjectMother.dbAttr("attr02").typeInt())).build();
        DataMap db = ObjectMother.dataMap().with(ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeInt(), ObjectMother.dbAttr("attr02").typeInt()), ObjectMother.dbEntity("table2").attributes(ObjectMother.dbAttr("attr01").typeInt().primaryKey(), ObjectMother.dbAttr("attr02").typeInt())).join("rel", "table1.attr01", "table2.attr01").build();
        List<MergerToken> tokens = this.dbMerger().createMergeTokens(existing.getDbEntities(), db.getDbEntities(), new DbLoaderConfiguration());
        Assert.assertEquals((long)1L, (long)tokens.size());
        DbEntity entity = db.getDbEntity("table1");
        Assert.assertEquals((Object)this.factory().createDropRelationshipToDb(entity, entity.getRelationship("rel")).getTokenValue(), (Object)tokens.get(0).getTokenValue());
    }

    @Test
    public void testRemoveColumn() throws Exception {
        DataMap existing = ObjectMother.dataMap().with(ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeInt())).build();
        DataMap db = ObjectMother.dataMap().with(ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeInt(), ObjectMother.dbAttr("attr02").typeInt())).build();
        List<MergerToken> tokens = this.dbMerger().createMergeTokens(existing.getDbEntities(), db.getDbEntities(), new DbLoaderConfiguration());
        Assert.assertEquals((long)1L, (long)tokens.size());
        DbEntity entity = db.getDbEntity("table1");
        Assert.assertEquals((Object)this.factory().createDropColumnToModel(entity, entity.getAttribute("attr02")).getTokenValue(), (Object)tokens.get(0).getTokenValue());
    }

    @Test
    public void testNoChanges() throws Exception {
        DataMap dataMap1 = ObjectMother.dataMap().with(ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeInt(), ObjectMother.dbAttr("attr02").typeInt(), ObjectMother.dbAttr("attr03").typeInt())).build();
        DataMap dataMap2 = ObjectMother.dataMap().with(ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeInt(), ObjectMother.dbAttr("attr02").typeInt(), ObjectMother.dbAttr("attr03").typeInt())).build();
        Assert.assertEquals((long)0L, (long)this.dbMerger().createMergeTokens(dataMap1.getDbEntities(), dataMap2.getDbEntities(), new DbLoaderConfiguration()).size());
    }

    private DbMerger dbMerger() {
        return new DbMerger(this.factory());
    }

    private HSQLMergerFactory factory() {
        return new HSQLMergerFactory();
    }
}

