/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.merge.AbstractToModelToken;
import org.apache.cayenne.merge.MergerContext;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;

public class AddRelationshipToModel
extends AbstractToModelToken.Entity {
    public static final String COMMA_SEPARATOR = ", ";
    public static final int COMMA_SEPARATOR_LENGTH = ", ".length();
    private DbRelationship rel;

    public AddRelationshipToModel(DbEntity entity, DbRelationship rel) {
        super("Add Relationship", entity);
        this.rel = rel;
    }

    @Override
    public MergerToken createReverse(MergerFactory factory) {
        return factory.createDropRelationshipToDb(this.getEntity(), this.rel);
    }

    @Override
    public void execute(MergerContext mergerContext) {
        this.getEntity().addRelationship(this.rel);
        this.synchronizeWithObjEntity(this.getEntity());
        mergerContext.getModelMergeDelegate().dbRelationshipAdded(this.rel);
    }

    @Override
    public String getTokenValue() {
        String attributes = "";
        if (this.rel.getJoins().size() == 1) {
            attributes = this.rel.getJoins().get(0).getTargetName();
        } else {
            for (DbJoin dbJoin : this.rel.getJoins()) {
                attributes = attributes + dbJoin.getTargetName() + COMMA_SEPARATOR;
            }
            attributes = "{" + attributes.substring(0, attributes.length() - COMMA_SEPARATOR_LENGTH) + "}";
        }
        return this.rel.getName() + " " + this.rel.getSourceEntity().getName() + "->" + this.rel.getTargetEntityName() + "." + attributes;
    }

    public static String getTokenValue(DbRelationship rel) {
        String attributes = "";
        if (rel.getJoins().size() == 1) {
            attributes = rel.getJoins().get(0).getTargetName();
        } else {
            for (DbJoin dbJoin : rel.getJoins()) {
                attributes = attributes + dbJoin.getTargetName() + COMMA_SEPARATOR;
            }
            attributes = "{" + attributes.substring(0, attributes.length() - COMMA_SEPARATOR_LENGTH) + "}";
        }
        return rel.getName() + " " + rel.getSourceEntity().getName() + "->" + rel.getTargetEntityName() + "." + attributes;
    }

    public DbRelationship getRelationship() {
        return this.rel;
    }
}

