/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import java.util.Collections;
import java.util.List;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.merge.AbstractToDbToken;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;

public class AddColumnToDb
extends AbstractToDbToken.EntityAndColumn {
    public AddColumnToDb(DbEntity entity, DbAttribute column) {
        super("Add Column", entity, column);
    }

    protected void appendPrefix(StringBuffer sqlBuffer, QuotingStrategy context) {
        sqlBuffer.append("ALTER TABLE ");
        sqlBuffer.append(context.quotedFullyQualifiedName(this.getEntity()));
        sqlBuffer.append(" ADD COLUMN ");
        sqlBuffer.append(context.quotedName(this.getColumn()));
        sqlBuffer.append(" ");
    }

    @Override
    public List<String> createSql(DbAdapter adapter) {
        StringBuffer sqlBuffer = new StringBuffer();
        QuotingStrategy context = adapter.getQuotingStrategy();
        this.appendPrefix(sqlBuffer, context);
        sqlBuffer.append(JdbcAdapter.getType(adapter, this.getColumn()));
        sqlBuffer.append(JdbcAdapter.sizeAndPrecision(adapter, this.getColumn()));
        return Collections.singletonList(sqlBuffer.toString());
    }

    @Override
    public MergerToken createReverse(MergerFactory factory) {
        return factory.createDropColumnToModel(this.getEntity(), this.getColumn());
    }
}

