/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.merge.MergeDirection;
import org.apache.cayenne.merge.MergerToken;
import org.apache.cayenne.merge.ModelMergeDelegate;
import org.apache.cayenne.util.EntityMergeSupport;

public abstract class AbstractToModelToken
implements MergerToken {
    private final String tokenName;

    protected AbstractToModelToken(String tokenName) {
        this.tokenName = tokenName;
    }

    @Override
    public final String getTokenName() {
        return this.tokenName;
    }

    @Override
    public final MergeDirection getDirection() {
        return MergeDirection.TO_MODEL;
    }

    protected void synchronizeWithObjEntity(DbEntity entity) {
        for (ObjEntity objEntity : entity.mappedObjEntities()) {
            new EntityMergeSupport(objEntity.getDataMap()).synchronizeWithDbEntity(objEntity);
        }
    }

    protected static void remove(ModelMergeDelegate mergerContext, DbRelationship rel, boolean reverse) {
        if (rel == null) {
            return;
        }
        if (reverse) {
            AbstractToModelToken.remove(mergerContext, rel.getReverseRelationship(), false);
        }
        DbEntity dbEntity = rel.getSourceEntity();
        for (ObjEntity objEntity : dbEntity.mappedObjEntities()) {
            AbstractToModelToken.remove(mergerContext, objEntity.getRelationshipForDbRelationship(rel), true);
        }
        rel.getSourceEntity().removeRelationship(rel.getName());
        mergerContext.dbRelationshipRemoved(rel);
    }

    protected static void remove(ModelMergeDelegate mergerContext, ObjRelationship rel, boolean reverse) {
        if (rel == null) {
            return;
        }
        if (reverse) {
            AbstractToModelToken.remove(mergerContext, rel.getReverseRelationship(), false);
        }
        rel.getSourceEntity().removeRelationship(rel.getName());
        mergerContext.objRelationshipRemoved(rel);
    }

    public String toString() {
        return this.getTokenName() + ' ' + this.getTokenValue() + ' ' + (Object)((Object)this.getDirection());
    }

    static abstract class EntityAndColumn
    extends Entity {
        private final DbAttribute column;

        protected EntityAndColumn(String tokenName, DbEntity entity, DbAttribute column) {
            super(tokenName, entity);
            this.column = column;
        }

        public DbAttribute getColumn() {
            return this.column;
        }

        @Override
        public String getTokenValue() {
            return this.getEntity().getName() + "." + this.getColumn().getName();
        }
    }

    static abstract class Entity
    extends AbstractToModelToken {
        private final DbEntity entity;

        protected Entity(String tokenName, DbEntity entity) {
            super(tokenName);
            this.entity = entity;
        }

        public DbEntity getEntity() {
            return this.entity;
        }

        @Override
        public String getTokenValue() {
            return this.getEntity().getName();
        }
    }
}

