/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.math.BigDecimal;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.ASTAdd;
import org.apache.cayenne.exp.parser.ASTAnd;
import org.apache.cayenne.exp.parser.ASTBetween;
import org.apache.cayenne.exp.parser.ASTDivide;
import org.apache.cayenne.exp.parser.ASTEqual;
import org.apache.cayenne.exp.parser.ASTFalse;
import org.apache.cayenne.exp.parser.ASTGreater;
import org.apache.cayenne.exp.parser.ASTGreaterOrEqual;
import org.apache.cayenne.exp.parser.ASTIn;
import org.apache.cayenne.exp.parser.ASTLess;
import org.apache.cayenne.exp.parser.ASTLessOrEqual;
import org.apache.cayenne.exp.parser.ASTLike;
import org.apache.cayenne.exp.parser.ASTLikeIgnoreCase;
import org.apache.cayenne.exp.parser.ASTList;
import org.apache.cayenne.exp.parser.ASTMultiply;
import org.apache.cayenne.exp.parser.ASTNegate;
import org.apache.cayenne.exp.parser.ASTNot;
import org.apache.cayenne.exp.parser.ASTNotBetween;
import org.apache.cayenne.exp.parser.ASTNotEqual;
import org.apache.cayenne.exp.parser.ASTNotIn;
import org.apache.cayenne.exp.parser.ASTNotLike;
import org.apache.cayenne.exp.parser.ASTNotLikeIgnoreCase;
import org.apache.cayenne.exp.parser.ASTObjPath;
import org.apache.cayenne.exp.parser.ASTOr;
import org.apache.cayenne.exp.parser.ASTSubtract;
import org.apache.cayenne.exp.parser.ASTTrue;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.apache.cayenne.unit.util.TstBean;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class ExpressionEvaluateInMemoryIT
extends ServerCase {
    @Inject
    private ServerRuntime runtime;
    @Inject
    private DataContext context;
    @Inject
    protected DBHelper dbHelper;
    protected TableHelper tArtist;
    protected TableHelper tPainting;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "ARTIST_ID", "PAINTING_TITLE", "ESTIMATED_PRICE"}).setColumnTypes(new int[]{4, -5, 12, 3});
    }

    protected void createTwoArtistsThreePaintings() throws Exception {
        this.tArtist.insert(new Object[]{1, "artist1"});
        this.tArtist.insert(new Object[]{2, "artist2"});
        this.tPainting.insert(new Object[]{1, 1, "P1", 3000});
        this.tPainting.insert(new Object[]{2, 2, "P2", 3000});
        this.tPainting.insert(new Object[]{3, null, "P3", 3000});
    }

    @Test
    public void testEvaluateOBJ_PATH_DataObject() throws Exception {
        ASTObjPath node = new ASTObjPath("artistName");
        Artist a1 = new Artist();
        a1.setArtistName("abc");
        Assert.assertEquals((Object)"abc", (Object)node.evaluate(a1));
        Artist a2 = new Artist();
        a2.setArtistName("123");
        Assert.assertEquals((Object)"123", (Object)node.evaluate(a2));
    }

    @Test
    public void testEvaluateOBJ_PATH_JavaBean() throws Exception {
        ASTObjPath node = new ASTObjPath("property2");
        TstBean b1 = new TstBean();
        b1.setProperty2(1);
        Assert.assertEquals((Object)new Integer(1), (Object)node.evaluate(b1));
        TstBean b2 = new TstBean();
        b2.setProperty2(-3);
        Assert.assertEquals((Object)new Integer(-3), (Object)node.evaluate(b2));
    }

    @Test
    public void testEvaluateOBJ_PATH_ObjEntity() throws Exception {
        ASTObjPath node = new ASTObjPath("paintingArray.paintingTitle");
        ObjEntity ae = this.runtime.getDataDomain().getEntityResolver().getObjEntity(Artist.class);
        Object target = node.evaluate(ae);
        Assert.assertTrue((boolean)(target instanceof ObjAttribute));
    }

    @Test
    public void testEvaluateDB_PATH_DbEntity() throws Exception {
        Expression e = Expression.fromString("db:paintingArray.PAINTING_TITLE");
        ObjEntity ae = this.runtime.getDataDomain().getEntityResolver().getObjEntity(Artist.class);
        DbEntity ade = ae.getDbEntity();
        Object objTarget = e.evaluate(ae);
        Assert.assertTrue((boolean)(objTarget instanceof DbAttribute));
        Object dbTarget = e.evaluate(ade);
        Assert.assertTrue((boolean)(dbTarget instanceof DbAttribute));
    }

    @Test
    public void testEvaluateEQUAL_TOBigDecimal() throws Exception {
        BigDecimal bd1 = new BigDecimal("2.0");
        BigDecimal bd2 = new BigDecimal("2.0");
        BigDecimal bd3 = new BigDecimal("2.00");
        BigDecimal bd4 = new BigDecimal("2.01");
        ASTEqual equalTo = new ASTEqual(new ASTObjPath("estimatedPrice"), bd1);
        Painting p = new Painting();
        p.setEstimatedPrice(bd2);
        Assert.assertTrue((boolean)equalTo.match(p));
        p.setEstimatedPrice(bd3);
        Assert.assertTrue((boolean)equalTo.match(p));
        p.setEstimatedPrice(bd4);
        Assert.assertFalse((boolean)equalTo.match(p));
    }

    @Test
    public void testEvaluateEQUAL_TO() throws Exception {
        ASTEqual equalTo = new ASTEqual(new ASTObjPath("artistName"), "abc");
        ASTNotEqual notEqualTo = new ASTNotEqual(new ASTObjPath("artistName"), "abc");
        Artist match = new Artist();
        match.setArtistName("abc");
        Assert.assertTrue((boolean)equalTo.match(match));
        Assert.assertFalse((boolean)notEqualTo.match(match));
        Artist noMatch = new Artist();
        noMatch.setArtistName("123");
        Assert.assertFalse((String)("Failed: " + equalTo), (boolean)equalTo.match(noMatch));
        Assert.assertTrue((String)("Failed: " + notEqualTo), (boolean)notEqualTo.match(noMatch));
    }

    @Test
    public void testEvaluateEQUAL_TO_Null() throws Exception {
        ASTEqual equalToNull = new ASTEqual(new ASTObjPath("artistName"), null);
        ASTEqual equalToNotNull = new ASTEqual(new ASTObjPath("artistName"), "abc");
        Artist match = new Artist();
        Assert.assertTrue((boolean)equalToNull.match(match));
        Assert.assertFalse((boolean)equalToNotNull.match(match));
        Artist noMatch = new Artist();
        noMatch.setArtistName("abc");
        Assert.assertFalse((boolean)equalToNull.match(noMatch));
    }

    @Test
    public void testEvaluateNOT_EQUAL_TONull() throws Exception {
        ASTNotEqual notEqualToNull = new ASTNotEqual(new ASTObjPath("artistName"), null);
        ASTNotEqual notEqualToNotNull = new ASTNotEqual(new ASTObjPath("artistName"), "abc");
        Artist match = new Artist();
        Assert.assertFalse((boolean)notEqualToNull.match(match));
        Assert.assertTrue((boolean)notEqualToNotNull.match(match));
        Artist noMatch = new Artist();
        noMatch.setArtistName("123");
        Assert.assertTrue((String)("Failed: " + notEqualToNull), (boolean)notEqualToNull.match(noMatch));
    }

    @Test
    public void testEvaluateEQUAL_TODataObject() throws Exception {
        Artist a1 = (Artist)this.context.newObject("Artist");
        Artist a2 = (Artist)this.context.newObject("Artist");
        Painting p1 = (Painting)this.context.newObject("Painting");
        Painting p2 = (Painting)this.context.newObject("Painting");
        Painting p3 = (Painting)this.context.newObject("Painting");
        a1.setArtistName("a1");
        a2.setArtistName("a2");
        p1.setPaintingTitle("p1");
        p2.setPaintingTitle("p2");
        p3.setPaintingTitle("p3");
        this.context.commitChanges();
        p1.setToArtist(a1);
        p2.setToArtist(a2);
        ASTEqual e = new ASTEqual(new ASTObjPath("toArtist"), a1);
        Assert.assertTrue((boolean)e.match(p1));
        Assert.assertFalse((boolean)e.match(p2));
        Assert.assertFalse((boolean)e.match(p3));
    }

    @Test
    public void testEvaluateEQUAL_TO_Temp_ObjectId() throws Exception {
        Artist a1 = (Artist)this.context.newObject("Artist");
        Artist a2 = (Artist)this.context.newObject("Artist");
        Painting p1 = (Painting)this.context.newObject("Painting");
        Painting p2 = (Painting)this.context.newObject("Painting");
        Painting p3 = (Painting)this.context.newObject("Painting");
        p1.setToArtist(a1);
        p2.setToArtist(a2);
        ASTEqual e = new ASTEqual(new ASTObjPath("toArtist"), a1.getObjectId());
        Assert.assertTrue((boolean)e.match(p1));
        Assert.assertFalse((boolean)e.match(p2));
        Assert.assertFalse((boolean)e.match(p3));
    }

    @Test
    public void testEvaluateEQUAL_TO_Id() throws Exception {
        this.createTwoArtistsThreePaintings();
        Artist a1 = Cayenne.objectForPK((ObjectContext)this.context, Artist.class, 1);
        Painting p1 = Cayenne.objectForPK((ObjectContext)this.context, Painting.class, 1);
        Painting p2 = Cayenne.objectForPK((ObjectContext)this.context, Painting.class, 2);
        Painting p3 = Cayenne.objectForPK((ObjectContext)this.context, Painting.class, 3);
        ASTEqual e = new ASTEqual(new ASTObjPath("toArtist"), Cayenne.intPKForObject(a1));
        Assert.assertTrue((boolean)e.match(p1));
        Assert.assertFalse((boolean)e.match(p2));
        Assert.assertFalse((boolean)e.match(p3));
    }

    @Test
    public void testEvaluateAND() throws Exception {
        ASTEqual e1 = new ASTEqual(new ASTObjPath("artistName"), "abc");
        ASTEqual e2 = new ASTEqual(new ASTObjPath("artistName"), "abc");
        ASTAnd e = new ASTAnd(new Object[]{e1, e2});
        Artist match = new Artist();
        match.setArtistName("abc");
        Assert.assertTrue((boolean)e.match(match));
        Artist noMatch = new Artist();
        noMatch.setArtistName("123");
        Assert.assertFalse((boolean)e.match(noMatch));
    }

    @Test
    public void testEvaluateOR() throws Exception {
        ASTEqual e1 = new ASTEqual(new ASTObjPath("artistName"), "abc");
        ASTEqual e2 = new ASTEqual(new ASTObjPath("artistName"), "xyz");
        ASTOr e = new ASTOr(new Object[]{e1, e2});
        Artist match1 = new Artist();
        match1.setArtistName("abc");
        Assert.assertTrue((String)("Failed: " + e), (boolean)e.match(match1));
        Artist match2 = new Artist();
        match2.setArtistName("xyz");
        Assert.assertTrue((String)("Failed: " + e), (boolean)e.match(match2));
        Artist noMatch = new Artist();
        noMatch.setArtistName("123");
        Assert.assertFalse((String)("Failed: " + e), (boolean)e.match(noMatch));
    }

    @Test
    public void testEvaluateNOT() throws Exception {
        ASTNot e = new ASTNot(new ASTEqual(new ASTObjPath("artistName"), "abc"));
        Artist noMatch = new Artist();
        noMatch.setArtistName("abc");
        Assert.assertFalse((boolean)e.match(noMatch));
        Artist match = new Artist();
        match.setArtistName("123");
        Assert.assertTrue((String)("Failed: " + e), (boolean)e.match(match));
    }

    @Test
    public void testEvaluateLESS_THAN() throws Exception {
        ASTLess e = new ASTLess(new ASTObjPath("estimatedPrice"), new BigDecimal(10000.0));
        Painting noMatch = new Painting();
        noMatch.setEstimatedPrice(new BigDecimal(10001));
        Assert.assertFalse((String)("Failed: " + e), (boolean)e.match(noMatch));
        Painting noMatch1 = new Painting();
        noMatch1.setEstimatedPrice(new BigDecimal(10000));
        Assert.assertFalse((String)("Failed: " + e), (boolean)e.match(noMatch1));
        Painting match = new Painting();
        match.setEstimatedPrice(new BigDecimal(9999));
        Assert.assertTrue((String)("Failed: " + e), (boolean)e.match(match));
    }

    @Test
    public void testEvaluateLESS_THAN_Null() throws Exception {
        ASTLess ltNull = new ASTLess(new ASTObjPath("estimatedPrice"), null);
        ASTLess ltNotNull = new ASTLess(new ASTObjPath("estimatedPrice"), new BigDecimal(10000.0));
        Painting noMatch = new Painting();
        Assert.assertFalse((boolean)ltNull.match(noMatch));
        Assert.assertFalse((boolean)ltNotNull.match(noMatch));
    }

    @Test
    public void testEvaluateLESS_THAN_EQUAL_TO() throws Exception {
        ASTLessOrEqual e = new ASTLessOrEqual(new ASTObjPath("estimatedPrice"), new BigDecimal(10000.0));
        Painting noMatch = new Painting();
        noMatch.setEstimatedPrice(new BigDecimal(10001));
        Assert.assertFalse((boolean)e.match(noMatch));
        Painting match1 = new Painting();
        match1.setEstimatedPrice(new BigDecimal(10000));
        Assert.assertTrue((boolean)e.match(match1));
        Painting match = new Painting();
        match.setEstimatedPrice(new BigDecimal(9999));
        Assert.assertTrue((String)("Failed: " + e), (boolean)e.match(match));
    }

    @Test
    public void testEvaluateLESS_THAN_EQUAL_TO_Null() throws Exception {
        ASTLessOrEqual ltNull = new ASTLessOrEqual(new ASTObjPath("estimatedPrice"), null);
        ASTLessOrEqual ltNotNull = new ASTLessOrEqual(new ASTObjPath("estimatedPrice"), new BigDecimal(10000.0));
        Painting noMatch = new Painting();
        Assert.assertFalse((boolean)ltNull.match(noMatch));
        Assert.assertFalse((boolean)ltNotNull.match(noMatch));
    }

    @Test
    public void testEvaluateGREATER_THAN() throws Exception {
        ASTGreater e = new ASTGreater(new ASTObjPath("estimatedPrice"), new BigDecimal(10000.0));
        Painting noMatch = new Painting();
        noMatch.setEstimatedPrice(new BigDecimal(9999));
        Assert.assertFalse((boolean)e.match(noMatch));
        Painting noMatch1 = new Painting();
        noMatch1.setEstimatedPrice(new BigDecimal(10000));
        Assert.assertFalse((boolean)e.match(noMatch1));
        Painting match = new Painting();
        match.setEstimatedPrice(new BigDecimal(10001));
        Assert.assertTrue((String)("Failed: " + e), (boolean)e.match(match));
    }

    @Test
    public void testEvaluateGREATER_THAN_Null() throws Exception {
        ASTGreater gtNull = new ASTGreater(new ASTObjPath("estimatedPrice"), null);
        ASTGreater gtNotNull = new ASTGreater(new ASTObjPath("estimatedPrice"), new BigDecimal(10000.0));
        Painting noMatch = new Painting();
        Assert.assertFalse((boolean)gtNull.match(noMatch));
        Assert.assertFalse((boolean)gtNotNull.match(noMatch));
    }

    @Test
    public void testEvaluateGREATER_THAN_EQUAL_TO() throws Exception {
        ASTGreaterOrEqual e = new ASTGreaterOrEqual(new ASTObjPath("estimatedPrice"), new BigDecimal(10000.0));
        Painting noMatch = new Painting();
        noMatch.setEstimatedPrice(new BigDecimal(9999));
        Assert.assertFalse((boolean)e.match(noMatch));
        Painting match1 = new Painting();
        match1.setEstimatedPrice(new BigDecimal(10000));
        Assert.assertTrue((boolean)e.match(match1));
        Painting match = new Painting();
        match.setEstimatedPrice(new BigDecimal(10001));
        Assert.assertTrue((String)("Failed: " + e), (boolean)e.match(match));
    }

    @Test
    public void testEvaluateGREATER_THAN_EQUAL_TO_Null() throws Exception {
        ASTGreaterOrEqual gtNull = new ASTGreaterOrEqual(new ASTObjPath("estimatedPrice"), null);
        ASTGreaterOrEqual gtNotNull = new ASTGreaterOrEqual(new ASTObjPath("estimatedPrice"), new BigDecimal(10000.0));
        Painting noMatch = new Painting();
        Assert.assertFalse((boolean)gtNull.match(noMatch));
        Assert.assertFalse((boolean)gtNotNull.match(noMatch));
    }

    @Test
    public void testEvaluateBETWEEN() throws Exception {
        ASTBetween between = new ASTBetween(new ASTObjPath("estimatedPrice"), new BigDecimal(10.0), new BigDecimal(20.0));
        ASTNotBetween notBetween = new ASTNotBetween(new ASTObjPath("estimatedPrice"), new BigDecimal(10.0), new BigDecimal(20.0));
        Painting noMatch = new Painting();
        noMatch.setEstimatedPrice(new BigDecimal(21));
        Assert.assertFalse((boolean)between.match(noMatch));
        Assert.assertTrue((boolean)notBetween.match(noMatch));
        Painting match1 = new Painting();
        match1.setEstimatedPrice(new BigDecimal(20));
        Assert.assertTrue((boolean)between.match(match1));
        Assert.assertFalse((boolean)notBetween.match(match1));
        Painting match2 = new Painting();
        match2.setEstimatedPrice(new BigDecimal(10));
        Assert.assertTrue((String)("Failed: " + between), (boolean)between.match(match2));
        Assert.assertFalse((String)("Failed: " + notBetween), (boolean)notBetween.match(match2));
        Painting match3 = new Painting();
        match3.setEstimatedPrice(new BigDecimal(11));
        Assert.assertTrue((String)("Failed: " + between), (boolean)between.match(match3));
        Assert.assertFalse((String)("Failed: " + notBetween), (boolean)notBetween.match(match3));
    }

    @Test
    public void testEvaluateBETWEEN_Null() throws Exception {
        ASTBetween btNull = new ASTBetween(new ASTObjPath("estimatedPrice"), new BigDecimal(10.0), new BigDecimal(20.0));
        ASTNotBetween btNotNull = new ASTNotBetween(new ASTObjPath("estimatedPrice"), new BigDecimal(10.0), new BigDecimal(20.0));
        Painting noMatch = new Painting();
        Assert.assertFalse((boolean)btNull.match(noMatch));
        Assert.assertFalse((boolean)btNotNull.match(noMatch));
    }

    @Test
    public void testEvaluateIN() throws Exception {
        ASTIn in = new ASTIn(new ASTObjPath("estimatedPrice"), new ASTList(new Object[]{new BigDecimal("10"), new BigDecimal("20")}));
        ASTNotIn notIn = new ASTNotIn(new ASTObjPath("estimatedPrice"), new ASTList(new Object[]{new BigDecimal("10"), new BigDecimal("20")}));
        Painting noMatch1 = new Painting();
        noMatch1.setEstimatedPrice(new BigDecimal("21"));
        Assert.assertFalse((boolean)in.match(noMatch1));
        Assert.assertTrue((boolean)notIn.match(noMatch1));
        Painting noMatch2 = new Painting();
        noMatch2.setEstimatedPrice(new BigDecimal("11"));
        Assert.assertFalse((String)("Failed: " + in), (boolean)in.match(noMatch2));
        Assert.assertTrue((String)("Failed: " + notIn), (boolean)notIn.match(noMatch2));
        Painting match1 = new Painting();
        match1.setEstimatedPrice(new BigDecimal("20"));
        Assert.assertTrue((boolean)in.match(match1));
        Assert.assertFalse((boolean)notIn.match(match1));
        Painting match2 = new Painting();
        match2.setEstimatedPrice(new BigDecimal("10"));
        Assert.assertTrue((String)("Failed: " + in), (boolean)in.match(match2));
        Assert.assertFalse((String)("Failed: " + notIn), (boolean)notIn.match(match2));
    }

    @Test
    public void testEvaluateIN_Null() throws Exception {
        ASTIn in = new ASTIn(new ASTObjPath("estimatedPrice"), new ASTList(new Object[]{new BigDecimal("10"), new BigDecimal("20")}));
        ASTNotIn notIn = new ASTNotIn(new ASTObjPath("estimatedPrice"), new ASTList(new Object[]{new BigDecimal("10"), new BigDecimal("20")}));
        Painting noMatch = new Painting();
        Assert.assertFalse((boolean)in.match(noMatch));
        Assert.assertFalse((boolean)notIn.match(noMatch));
    }

    @Test
    public void testEvaluateLIKE1() throws Exception {
        ASTLike like = new ASTLike(new ASTObjPath("artistName"), "abc%d");
        ASTNotLike notLike = new ASTNotLike(new ASTObjPath("artistName"), "abc%d");
        Artist noMatch = new Artist();
        noMatch.setArtistName("dabc");
        Assert.assertFalse((boolean)like.match(noMatch));
        Assert.assertTrue((boolean)notLike.match(noMatch));
        Artist match1 = new Artist();
        match1.setArtistName("abc123d");
        Assert.assertTrue((String)("Failed: " + like), (boolean)like.match(match1));
        Assert.assertFalse((String)("Failed: " + notLike), (boolean)notLike.match(match1));
        Artist match2 = new Artist();
        match2.setArtistName("abcd");
        Assert.assertTrue((String)("Failed: " + like), (boolean)like.match(match2));
        Assert.assertFalse((String)("Failed: " + notLike), (boolean)notLike.match(match2));
    }

    @Test
    public void testEvaluateLIKE2() throws Exception {
        ASTLike like = new ASTLike(new ASTObjPath("artistName"), "abc?d");
        ASTNotLike notLike = new ASTNotLike(new ASTObjPath("artistName"), "abc?d");
        Artist noMatch1 = new Artist();
        noMatch1.setArtistName("dabc");
        Assert.assertFalse((boolean)like.match(noMatch1));
        Assert.assertTrue((boolean)notLike.match(noMatch1));
        Artist noMatch2 = new Artist();
        noMatch2.setArtistName("abc123d");
        Assert.assertFalse((String)("Failed: " + like), (boolean)like.match(noMatch2));
        Assert.assertTrue((String)("Failed: " + notLike), (boolean)notLike.match(noMatch2));
        Artist match = new Artist();
        match.setArtistName("abcXd");
        Assert.assertTrue((String)("Failed: " + like), (boolean)like.match(match));
        Assert.assertFalse((String)("Failed: " + notLike), (boolean)notLike.match(match));
    }

    @Test
    public void testEvaluateLIKE3() throws Exception {
        ASTLike like = new ASTLike(new ASTObjPath("artistName"), "/./");
        Artist noMatch1 = new Artist();
        noMatch1.setArtistName("/a/");
        Assert.assertFalse((boolean)like.match(noMatch1));
        Artist match = new Artist();
        match.setArtistName("/./");
        Assert.assertTrue((String)("Failed: " + like), (boolean)like.match(match));
    }

    @Test
    public void testEvaluateLIKE_IGNORE_CASE() throws Exception {
        ASTLikeIgnoreCase like = new ASTLikeIgnoreCase(new ASTObjPath("artistName"), "aBcD");
        ASTNotLikeIgnoreCase notLike = new ASTNotLikeIgnoreCase(new ASTObjPath("artistName"), "aBcD");
        Artist noMatch1 = new Artist();
        noMatch1.setArtistName("dabc");
        Assert.assertFalse((boolean)like.match(noMatch1));
        Assert.assertTrue((boolean)notLike.match(noMatch1));
        Artist match1 = new Artist();
        match1.setArtistName("abcd");
        Assert.assertTrue((String)("Failed: " + like), (boolean)like.match(match1));
        Assert.assertFalse((String)("Failed: " + notLike), (boolean)notLike.match(match1));
        Artist match2 = new Artist();
        match2.setArtistName("ABcD");
        Assert.assertTrue((String)("Failed: " + like), (boolean)like.match(match2));
        Assert.assertFalse((String)("Failed: " + notLike), (boolean)notLike.match(match2));
    }

    @Test
    public void testEvaluateADD() throws Exception {
        ASTAdd add = new ASTAdd(new Object[]{new Integer(1), new Double(5.5)});
        Assert.assertEquals((double)6.5, (double)((Number)((Expression)add).evaluate(null)).doubleValue(), (double)1.0E-4);
    }

    @Test
    public void testEvaluateSubtract() throws Exception {
        ASTSubtract subtract = new ASTSubtract(new Object[]{new Integer(1), new Double(0.1), new Double(0.2)});
        Assert.assertEquals((double)0.7, (double)((Number)((Expression)subtract).evaluate(null)).doubleValue(), (double)1.0E-4);
    }

    @Test
    public void testEvaluateMultiply() throws Exception {
        ASTMultiply multiply = new ASTMultiply(new Object[]{new Integer(2), new Double(3.5)});
        Assert.assertEquals((double)7.0, (double)((Number)((Expression)multiply).evaluate(null)).doubleValue(), (double)1.0E-4);
    }

    @Test
    public void testEvaluateDivide() throws Exception {
        ASTDivide divide = new ASTDivide(new Object[]{new BigDecimal("7.0"), new BigDecimal("2.0")});
        Assert.assertEquals((double)3.5, (double)((Number)((Expression)divide).evaluate(null)).doubleValue(), (double)1.0E-4);
    }

    @Test
    public void testEvaluateNegate() throws Exception {
        Assert.assertEquals((long)-3L, (long)((Number)new ASTNegate(new Integer(3)).evaluate(null)).intValue());
        Assert.assertEquals((long)5L, (long)((Number)new ASTNegate(new Integer(-5)).evaluate(null)).intValue());
    }

    @Test
    public void testEvaluateTrue() throws Exception {
        Assert.assertEquals((Object)Boolean.TRUE, (Object)new ASTTrue().evaluate(null));
    }

    @Test
    public void testEvaluateFalse() throws Exception {
        Assert.assertEquals((Object)Boolean.FALSE, (Object)new ASTFalse().evaluate(null));
    }
}

