/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp;

import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.TraversalHandler;
import org.junit.Assert;

public class TstTraversalHandler
implements TraversalHandler {
    protected List<Object> treeFlatView = new ArrayList<Object>();
    protected int children;
    protected int nodes;
    protected int nodesStarted;
    protected int leafs;

    public static void compareExps(Expression exp1, Expression exp2) {
        TstTraversalHandler handler1 = new TstTraversalHandler();
        handler1.traverseExpression(exp1);
        TstTraversalHandler handler2 = new TstTraversalHandler();
        handler2.traverseExpression(exp2);
        Assert.assertEquals((long)handler1.nodes, (long)handler2.nodes);
    }

    public void assertConsistency() throws Exception {
        Assert.assertEquals((long)this.nodesStarted, (long)this.nodes);
    }

    public List<Object> getTreeFlatView() {
        return this.treeFlatView;
    }

    public void traverseExpression(Expression exp) {
        this.reset();
        exp.traverse(this);
    }

    public void reset() {
        this.children = 0;
        this.nodes = 0;
        this.nodesStarted = 0;
        this.leafs = 0;
    }

    public int getNodeCount() {
        return this.nodes;
    }

    public int getChildren() {
        return this.children;
    }

    public int getNodes() {
        return this.nodes;
    }

    public int getNodesStarted() {
        return this.nodesStarted;
    }

    public int getLeafs() {
        return this.leafs;
    }

    @Override
    public void finishedChild(Expression node, int childIndex, boolean hasMoreChildren) {
        ++this.children;
    }

    @Override
    public void startNode(Expression node, Expression parentNode) {
        this.treeFlatView.add(node);
        ++this.nodesStarted;
    }

    @Override
    public void endNode(Expression node, Expression parentNode) {
        ++this.nodes;
    }

    @Override
    public void objectNode(Object leaf, Expression parentNode) {
        this.treeFlatView.add(leaf);
        ++this.leafs;
    }
}

